/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.docstream.DocStreamFactory;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.net.URI;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.ForbiddenException;
import net.mapeadores.util.servlets.exceptions.NotFoundException;
import net.mapeadores.util.servlets.handlers.DocStreamResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;

public class StreamInstruction
implements BdfInstruction {
    private static final short MANDATORY_ADMIN = -1;
    private final String rootDir;
    private final String filePath;
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final short userNeed;

    public StreamInstruction(BdfServer bdfServer, RequestMap requestMap, String rootDir, String filePath) {
        this.bdfServer = bdfServer;
        this.rootDir = rootDir;
        this.filePath = filePath;
        this.requestMap = requestMap;
        this.userNeed = StreamInstruction.getBdfUserNeed(rootDir, filePath);
    }

    @Override
    public short getBdfUserNeed() {
        if (this.userNeed == -1) {
            return 3;
        }
        return this.userNeed;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        if (this.userNeed == -1 && !BdfUserUtils.isAdmin(this.bdfServer, bdfUser)) {
            throw new ForbiddenException();
        }
        URI uri = BdfURI.toAbsoluteBdfURI(this.rootDir + "/" + this.filePath);
        if (uri == null) {
            throw new NotFoundException();
        }
        try {
            DocStream docStream = DocStreamFactory.parseDocStream(this.bdfServer, uri);
            if (docStream != null) {
                return new DocStreamResponseHandler(docStream);
            }
            throw new NotFoundException();
        }
        catch (ErrorMessageException eme) {
            MessageLocalisation messageLocalisation = BdfInstructionUtils.getMessageLocalisation(this.requestMap, this.bdfServer, bdfUser);
            return ResponseHandlerFactory.getHtmlInstance(messageLocalisation, eme.getErrorMessage());
        }
    }

    private static short getBdfUserNeed(String rootDir, String filePath) {
        switch (rootDir) {
            case "dyn": 
            case "inc": {
                return -1;
            }
            case "transformations": 
            case "transformation": 
            case "tableexport": 
            case "balayagecontents": 
            case "balayage": 
            case "illustrations": {
                return 3;
            }
            case "xml-pack": {
                int idx = filePath.indexOf(47);
                if (idx == -1) {
                    return 2;
                }
                return StreamInstruction.getBdfUserNeed(filePath.substring(0, idx), filePath.substring(idx + 1));
            }
            case "output": {
                if (filePath.startsWith("pub/")) {
                    return 2;
                }
                return 3;
            }
            case "dyn-pub": {
                return 1;
            }
        }
        if (filePath.endsWith(".ini")) {
            return -1;
        }
        if (filePath.contains("/private/")) {
            return 3;
        }
        return 2;
    }
}

