/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.access;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.table.CellConversionInit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.access.AccessDef;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.ErrorMessageException;

public class AccessGate {
    private final BdfServer bdfServer;
    private final AccessDef accessDef;
    private final Lang lang;
    private final Predicate<FicheMeta> fichePredicate;
    private final Predicate<Motcle> motclePredicate;
    private final Predicate<SubsetItem> commonPredicate;
    private final Predicate<Subset> subsetPredicate;
    private final SelectionContext selectionContext;
    private final PermissionSummary permissionSummary;

    private AccessGate(BdfServer bdfServer, AccessDef accessDef, Lang lang, Predicate<FicheMeta> fichePredicate, Predicate<Motcle> motclePredicate, Predicate<Subset> subsetPredicate, SelectionContext selectionContext, PermissionSummary permissionSummary) {
        this.bdfServer = bdfServer;
        this.accessDef = accessDef;
        this.lang = lang;
        this.fichePredicate = fichePredicate;
        this.motclePredicate = motclePredicate;
        this.commonPredicate = new CommonPredicate();
        this.subsetPredicate = subsetPredicate;
        this.selectionContext = selectionContext;
        this.permissionSummary = permissionSummary;
    }

    public BdfServer getBdfServer() {
        return this.bdfServer;
    }

    public AccessDef getAccessDef() {
        return this.accessDef;
    }

    public Lang getLang() {
        return this.lang;
    }

    public Predicate<FicheMeta> getFichePredicate() {
        return this.fichePredicate;
    }

    public Predicate<Motcle> getMotclePredicate() {
        return this.motclePredicate;
    }

    public Predicate<SubsetItem> getSubsetItemPredicate() {
        return this.commonPredicate;
    }

    public Predicate<Subset> getSubsetPredicate() {
        return this.subsetPredicate;
    }

    public SelectionContext getSelectionContext() {
        return this.selectionContext;
    }

    public PermissionSummary getPermissionSummary() {
        return this.permissionSummary;
    }

    public CellConverter getCellConverter() {
        String tableExportName = this.accessDef.getTableExportName();
        if (tableExportName.isEmpty()) {
            return TableExportUtils.EMPTY_SUMCELLCONVERTER;
        }
        ExtractionContext extractionContext = BdfServerUtils.initExtractionContextBuilder(this.bdfServer, LocalisationUtils.toUserLangContext(this.selectionContext.getWorkingLang()), this.permissionSummary).toExtractionContext();
        try {
            return CellConversionInit.fromTableExportName(this.bdfServer, extractionContext, tableExportName, this.commonPredicate).getCellConverter();
        }
        catch (ErrorMessageException eme) {
            return TableExportUtils.EMPTY_CELLCONVERTER;
        }
    }

    public static AccessGate build(BdfServer bdfServer, AccessDef accessDef, PermissionSummary permissionSummary, Lang lang) {
        MotclePredicateBuffer motclePredicate;
        FichothequeQueries fichothequeQueries = BdfServerUtils.resolveSelectionOptions(bdfServer, accessDef.getSelectionOptions());
        List<FicheQuery> ficheQueryList = fichothequeQueries.getFicheQueryList();
        FicheSelector ficheSelector = null;
        FichePredicateBuffer fichePredicate = null;
        if (!ficheQueryList.isEmpty()) {
            SelectionContextBuilder builder = BdfServerUtils.initSelectionContextBuilder(bdfServer, lang);
            if (permissionSummary != null) {
                builder.setSubsetAccessPredicate(permissionSummary.getSubsetAccessPredicate());
            } else {
                builder.setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE);
            }
            FicheSelectorBuilder ficheSelectorBuilder = FicheSelectorBuilder.init(builder.toSelectionContext());
            for (FicheQuery ficheQuery : ficheQueryList) {
                ficheSelectorBuilder.add(ficheQuery);
            }
            ficheSelector = ficheSelectorBuilder.toFicheSelector();
            fichePredicate = new FichePredicateBuffer(ficheSelectorBuilder.toFicheSelector());
        }
        List<MotcleQuery> motcleQueryList = fichothequeQueries.getMotcleQueryList();
        MotcleSelector motcleSelector = null;
        if (!motcleQueryList.isEmpty()) {
            SelectionContextBuilder builder = BdfServerUtils.initSelectionContextBuilder(bdfServer, lang).setFichePredicate(fichePredicate);
            if (permissionSummary != null) {
                builder.setSubsetAccessPredicate(permissionSummary.getSubsetAccessPredicate());
            }
            MotcleSelectorBuilder motcleSelectorBuilder = MotcleSelectorBuilder.init(builder.toSelectionContext());
            for (MotcleQuery motcleQuery : motcleQueryList) {
                motcleSelectorBuilder.add(motcleQuery, null);
            }
            motcleSelector = motcleSelectorBuilder.toMotcleSelector();
            motclePredicate = new MotclePredicateBuffer(motcleSelector);
        } else {
            motclePredicate = EligibilityUtils.ALL_MOTCLE_PREDICATE;
        }
        if (fichePredicate == null) {
            fichePredicate = EligibilityUtils.ALL_FICHE_PREDICATE;
        }
        Set<SubsetKey> subsetKeySet = AccessGate.getAccessSubsetKey(bdfServer.getFichotheque(), ficheSelector, motcleSelector);
        SubsetPredicate subsetPredicate = new SubsetPredicate(subsetKeySet);
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(bdfServer, lang).setFichePredicate(fichePredicate).setSubsetAccessPredicate(subsetPredicate).toSelectionContext();
        if (permissionSummary == null) {
            permissionSummary = new PublicPermissionSummary(fichePredicate, subsetPredicate);
        }
        return new AccessGate(bdfServer, accessDef, lang, fichePredicate, motclePredicate, subsetPredicate, selectionContext, permissionSummary);
    }

    private static Set<SubsetKey> getAccessSubsetKey(Fichotheque fichotheque, FicheSelector ficheSelector, MotcleSelector motcleSelector) {
        HashSet<SubsetKey> set = new HashSet<SubsetKey>();
        List<Corpus> corpusList = ficheSelector != null ? ficheSelector.getCorpusList() : fichotheque.getCorpusList();
        for (Corpus corpus : corpusList) {
            set.add(corpus.getSubsetKey());
        }
        List<Thesaurus> thesaurusList = motcleSelector != null ? motcleSelector.getThesaurusList() : fichotheque.getThesaurusList();
        for (Thesaurus thesaurus : thesaurusList) {
            set.add(thesaurus.getSubsetKey());
        }
        return set;
    }

    private class CommonPredicate
    implements Predicate<SubsetItem> {
        private CommonPredicate() {
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            if (subsetItem instanceof FicheMeta) {
                return AccessGate.this.fichePredicate.test((FicheMeta)subsetItem);
            }
            if (subsetItem instanceof Motcle) {
                return AccessGate.this.motclePredicate.test((Motcle)subsetItem);
            }
            return true;
        }
    }

    private static class FichePredicateBuffer
    implements Predicate<FicheMeta> {
        private final Map<FicheMeta, Boolean> map = new HashMap<FicheMeta, Boolean>();
        private final FicheSelector ficheSelector;

        private FichePredicateBuffer(FicheSelector ficheSelector) {
            this.ficheSelector = ficheSelector;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            Boolean bool = this.map.get(ficheMeta);
            if (bool != null) {
                return bool;
            }
            if (this.ficheSelector.test(ficheMeta)) {
                this.map.put(ficheMeta, Boolean.TRUE);
                return true;
            }
            this.map.put(ficheMeta, Boolean.FALSE);
            return false;
        }
    }

    private static class MotclePredicateBuffer
    implements Predicate<Motcle> {
        private final Map<Motcle, Boolean> map = new HashMap<Motcle, Boolean>();
        private final MotcleSelector motcleSelector;

        private MotclePredicateBuffer(MotcleSelector motcleSelector) {
            this.motcleSelector = motcleSelector;
        }

        @Override
        public boolean test(Motcle motcle) {
            Boolean bool = this.map.get(motcle);
            if (bool != null) {
                return bool;
            }
            if (this.motcleSelector.test(motcle)) {
                this.map.put(motcle, Boolean.TRUE);
                return true;
            }
            this.map.put(motcle, Boolean.FALSE);
            return false;
        }
    }

    private static class SubsetPredicate
    implements Predicate<Subset> {
        private final Set<SubsetKey> set;

        private SubsetPredicate(Set<SubsetKey> set) {
            this.set = set;
        }

        @Override
        public boolean test(Subset subset) {
            SubsetKey subsetKey = subset.getSubsetKey();
            if (subsetKey.isAddendaSubset() || subsetKey.isAlbumSubset()) {
                return true;
            }
            return this.set.contains(subsetKey);
        }
    }

    private static class PublicPermissionSummary
    implements PermissionSummary {
        private final Predicate<FicheMeta> fichePredicate;
        private final Predicate<Subset> subsetPredicate;

        private PublicPermissionSummary(Predicate<FicheMeta> fichePredicate, Predicate<Subset> subsetPredicate) {
            this.fichePredicate = fichePredicate;
            this.subsetPredicate = subsetPredicate;
        }

        @Override
        public int getReadLevel(SubsetKey subsetKey) {
            if (subsetKey.isAddendaSubset() || subsetKey.isAlbumSubset()) {
                return 3;
            }
            return 4;
        }

        @Override
        public int getWriteLevel(SubsetKey subsetKey) {
            return 0;
        }

        @Override
        public boolean canCreate(SubsetKey subsetKey) {
            return false;
        }

        @Override
        public boolean isSubsetAdmin(SubsetKey subsetKey) {
            return false;
        }

        @Override
        public boolean isFichothequeAdmin() {
            return false;
        }

        @Override
        public boolean hasRole(String roleName) {
            return false;
        }

        @Override
        public boolean canDo(String actionName) {
            return false;
        }

        @Override
        public Predicate<Subset> getSubsetAccessPredicate() {
            return this.subsetPredicate;
        }

        @Override
        public boolean canWrite(FicheMeta ficheMeta) {
            return false;
        }

        @Override
        public boolean canRead(FicheMeta ficheMeta) {
            return this.fichePredicate.test(ficheMeta);
        }
    }
}

