/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.conf;

import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.ConfDirs;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.exceptions.InitException;

public class WebappDirs
implements ConfDirs {
    private final boolean multiBdf;
    private final Map<String, File> dirMap;

    private WebappDirs(boolean multiBdf, Map<String, File> dirMap) {
        this.multiBdf = multiBdf;
        this.dirMap = dirMap;
    }

    public boolean isMultiBdf() {
        return this.multiBdf;
    }

    public BdfServerDirs getBdfServerDirs(String name) {
        if (this.multiBdf) {
            return new MultiDirs(name);
        }
        return new UniqueDirs();
    }

    public ConfDirs getMultiDirs() {
        if (!this.multiBdf) {
            throw new IllegalStateException("not a multi instance");
        }
        return new MultiDirs("_multi");
    }

    @Override
    public File getDir(String dirKey) {
        return this.dirMap.get(dirKey);
    }

    public static WebappDirs build(boolean multiBdf, File etcDirectory, File varDirectory, Map<String, File> customDirMap) {
        HashMap<String, File> dirMap = new HashMap<String, File>();
        for (Map.Entry<String, File> entry : customDirMap.entrySet()) {
            dirMap.put(WebappDirs.checkAlias(entry.getKey()), entry.getValue());
        }
        WebappDirs.checkKey(dirMap, "etc.config", etcDirectory);
        WebappDirs.checkKey(dirMap, "etc.config.default", etcDirectory);
        WebappDirs.checkKey(dirMap, "etc.resources", etcDirectory);
        WebappDirs.checkKey(dirMap, "etc.scripts", etcDirectory);
        WebappDirs.checkKey(dirMap, "var.data", varDirectory);
        WebappDirs.checkKey(dirMap, "var.output", varDirectory);
        WebappDirs.checkKey(dirMap, "var.cache", varDirectory);
        WebappDirs.checkKey(dirMap, "var.backup", varDirectory);
        WebappDirs.checkKey(dirMap, "var.run", varDirectory);
        dirMap.put("etc.", etcDirectory);
        dirMap.put("var.", varDirectory);
        WebappDirs.checkVarDirectories(dirMap);
        return new WebappDirs(multiBdf, dirMap);
    }

    private static void checkKey(Map<String, File> dirMap, String dirKey, File parentDir) {
        if (dirMap.containsKey(dirKey)) {
            return;
        }
        File dir = WebappDirs.getDefaultSubdir(parentDir, dirKey);
        dirMap.put(dirKey, dir);
    }

    private static void checkVarDirectories(Map<String, File> dirMap) {
        for (Map.Entry<String, File> entry : dirMap.entrySet()) {
            switch (entry.getKey()) {
                case "var.data": 
                case "var.output": 
                case "var.cache": 
                case "var.backup": {
                    boolean done;
                    File dir = entry.getValue();
                    if (dir.exists() || (done = dir.mkdirs())) break;
                    throw new InitException("Unable to create var directory: " + dir.getPath());
                }
            }
        }
    }

    private static File getDefaultSubdir(File parentDir, String dirKey) {
        switch (dirKey) {
            case "etc.config": {
                return new File(parentDir, "config");
            }
            case "etc.config.default": {
                return new File(parentDir, "config");
            }
            case "etc.resources": {
                return new File(parentDir, "resources");
            }
            case "etc.scripts": {
                return new File(parentDir, "scripts");
            }
            case "var.data": {
                return parentDir;
            }
            case "var.output": {
                return WebappDirs.checkFile(parentDir, "_output", "output");
            }
            case "var.cache": {
                return WebappDirs.checkFile(parentDir, "_cache", "cache");
            }
            case "var.backup": {
                return WebappDirs.checkFile(parentDir, "_backup", "backup");
            }
            case "var.run": {
                return new File(parentDir, "_run");
            }
        }
        return parentDir;
    }

    private static File checkFile(File parentDir, String dirName, String alias) {
        File aliasFile;
        File result = new File(parentDir, dirName);
        if (!result.exists() && (aliasFile = new File(parentDir, alias)).exists()) {
            aliasFile.renameTo(result);
        }
        return result;
    }

    private static String checkAlias(String dirKey) {
        switch (dirKey) {
            case "usr.extensionlib": 
            case "usr.extensions": {
                return "lib.extensions";
            }
        }
        return dirKey;
    }

    private class MultiDirs
    implements BdfServerDirs {
        private final String name;

        private MultiDirs(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public File getDir(String dirKey) {
            switch (dirKey) {
                case "etc.": 
                case "etc.config.default": 
                case "etc.resources": 
                case "var.": 
                case "lib.extensions": {
                    return (File)WebappDirs.this.dirMap.get(dirKey);
                }
            }
            if (dirKey.startsWith("custom.")) {
                return (File)WebappDirs.this.dirMap.get(dirKey);
            }
            return new File((File)WebappDirs.this.dirMap.get(dirKey), this.name);
        }
    }

    private class UniqueDirs
    implements BdfServerDirs {
        private UniqueDirs() {
        }

        @Override
        public String getName() {
            return "_unique";
        }

        @Override
        public File getDir(String dirKey) {
            return (File)WebappDirs.this.dirMap.get(dirKey);
        }
    }
}

