/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusLangListCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusLangList";
    public static final String COMMANDKEY = "_ THS-03";
    public static final String LANGLIST_PARAMNAME = "langlist";
    private Thesaurus thesaurus;
    private Langs langs;

    public ThesaurusLangListCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusMetadataEditor thesaurusMetadataEditor = session.getFichothequeEditor().getThesaurusEditor(this.thesaurus).getThesaurusMetadataEditor();
            done = thesaurusMetadataEditor.setAuthorizedLangs(this.langs);
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        if (done) {
            this.setDone("_ done.thesaurus.langlist", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        String langListString = this.getMandatory(LANGLIST_PARAMNAME);
        this.langs = LangsUtils.toCleanLangs(langListString);
        if (this.langs.isEmpty()) {
            throw BdfErrors.error("_ error.empty.langlist");
        }
    }
}

