/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ParentChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ParentChange";
    public static final String COMMANDKEY = "_ THS-10";
    public static final String NEWPARENT_PARAMNAME = "newparent";
    private Motcle motcle;
    private Motcle parentMotcle;

    public ParentChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Thesaurus thesaurus = this.motcle.getThesaurus();
        boolean done = false;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(thesaurus);
            try {
                done = thesaurusEditor.setParent(this.motcle, this.parentMotcle);
            }
            catch (ParentRecursivityException parentRecursivityException) {
                // empty catch block
            }
        }
        this.putResultObject("obj.thesaurus", thesaurus);
        this.putResultObject("obj.motcle", this.motcle);
        if (done) {
            this.setDone("_ done.thesaurus.parentchange", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        Thesaurus thesaurus = this.motcle.getThesaurus();
        String idParentString = this.getMandatory(NEWPARENT_PARAMNAME).trim();
        if (idParentString.length() > 0) {
            try {
                this.parentMotcle = thesaurus.getMotcleByIdString(idParentString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.parentMotcle == null) {
                throw BdfErrors.error("_ error.unknown.parentmotcle", idParentString);
            }
        }
        if (this.parentMotcle != null && this.parentMotcle.equals(this.motcle)) {
            throw BdfErrors.error("_ error.unsupported.selfparent");
        }
        if (this.parentMotcle != null && this.parentMotcle.isDescendantOf(this.motcle)) {
            Object[] objserr = new Object[2];
            if (thesaurus.isIdalphaType()) {
                objserr[0] = this.motcle.getIdalpha();
                objserr[1] = this.parentMotcle.getIdalpha();
            } else {
                objserr[0] = this.motcle.getId();
                objserr[1] = this.parentMotcle.getId();
            }
            throw BdfErrors.error("_ error.unsupported.recursiveparent", objserr);
        }
    }
}

