/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.junction.TieBuffer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotclePonderationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotclePonderation";
    public static final String COMMANDKEY = "_ THS-14";
    private Motcle motcle;
    private final Map<String, PonderationByCorpus> ponderationByCorpusMap = new HashMap<String, PonderationByCorpus>();

    public MotclePonderationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            JunctionEditor junctionEditor = session.getFichothequeEditor().getJunctionEditor();
            JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendOrWeightReplaceEngine(this.motcle);
            for (PonderationByCorpus ponderationByCorpus : this.ponderationByCorpusMap.values()) {
                for (TieBuffer tieBuffer : ponderationByCorpus.getTieBufferList()) {
                    junctionChangeEngine.addTie(tieBuffer);
                }
            }
            junctionEditor.updateJunctions(this.motcle, junctionChangeEngine.toJunctionChanges());
        }
        this.putResultObject("obj.thesaurus", this.motcle.getThesaurus());
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.thesaurus.motcleponderation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        HashSet<String> wrongCorpusSet = new HashSet<String>();
        String mode = "";
        for (String paramName : this.requestHandler.getParameterNameSet()) {
            int idx = paramName.indexOf(95);
            if (idx == -1) continue;
            try {
                String corpusName;
                int id = Integer.parseInt(paramName.substring(idx + 1));
                String weightString = this.requestHandler.getTrimedParameter(paramName);
                int weight = 1;
                if (!weightString.isEmpty()) {
                    weight = Integer.parseInt(weightString);
                }
                if (weight < 1 || wrongCorpusSet.contains(corpusName = paramName.substring(0, idx))) continue;
                PonderationByCorpus ponderationByCorpus = this.ponderationByCorpusMap.get(corpusName);
                if (ponderationByCorpus == null) {
                    Corpus corpus = this.fichotheque.getCorpus(corpusName);
                    if (corpus == null || !this.getPermissionSummary().hasAccess(corpus)) {
                        wrongCorpusSet.add(corpusName);
                        continue;
                    }
                    ponderationByCorpus = new PonderationByCorpus(corpus);
                    this.ponderationByCorpusMap.put(corpusName, ponderationByCorpus);
                }
                ponderationByCorpus.add(id, mode, weight);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static class PonderationByCorpus {
        private final Corpus corpus;
        private final List<TieBuffer> tieBufferList = new ArrayList<TieBuffer>();

        private PonderationByCorpus(Corpus corpus) {
            this.corpus = corpus;
        }

        private void add(int id, String mode, int weight) {
            FicheMeta ficheMeta = this.corpus.getFicheMetaById(id);
            if (ficheMeta != null) {
                this.tieBufferList.add(new TieBuffer(ficheMeta, mode, weight));
            }
        }

        private List<TieBuffer> getTieBufferList() {
            return this.tieBufferList;
        }

        private Corpus getCorpus() {
            return this.corpus;
        }
    }
}

