/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.api.users.BdfUserPrefsEditor;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurTemplatesCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurTemplates";
    public static final String COMMANDKEY = "_ USR-04";
    private BdfUserPrefs redacBdfUserPrefs;

    public RedacteurTemplatesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            this.saveKeys(session.getBdfServerEditor().getBdfUserPrefsEditor(this.redacBdfUserPrefs));
        }
        this.setDone("_ done.sphere.redacteurtemplates", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        Redacteur redacteur = this.requestHandler.getMandatoryRedacteur();
        boolean isSame = BdfUserUtils.isSame(this.bdfUser, redacteur);
        if (!isSame) {
            this.checkSubsetAdmin(redacteur.getSphere());
        }
        this.redacBdfUserPrefs = isSame ? this.bdfUser.getPrefs() : this.bdfServer.createBdfUser(redacteur).getPrefs();
    }

    private void saveKeys(BdfUserPrefsEditor bdfUserPrefsEditor) throws ErrorMessageException {
        this.saveTransformationKey(bdfUserPrefsEditor, TransformationKey.COMPILATION_INSTANCE);
        this.saveTransformationKey(bdfUserPrefsEditor, TransformationKey.STATTHESAURUS_INSTANCE);
        this.saveTransformationKey(bdfUserPrefsEditor, TransformationKey.INVERSETHESAURUS_INSTANCE);
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            TransformationKey transformationKey = new TransformationKey(corpus.getSubsetKey());
            this.saveTransformationKey(bdfUserPrefsEditor, transformationKey);
        }
    }

    private void saveTransformationKey(BdfUserPrefsEditor bdfUserPrefsEditor, TransformationKey transformationKey) throws ErrorMessageException {
        if (this.requestHandler.hasParameter(transformationKey.getKeyString())) {
            String value = this.requestHandler.getTrimedParameter(transformationKey.getKeyString());
            AttributeKey attributeKey = BdfUserSpace.toSimpleTemplateAttributeKey(transformationKey);
            if (value.equals("_default")) {
                bdfUserPrefsEditor.removeAttribute(attributeKey);
            } else {
                Attribute attribute = AttributeBuilder.toAttribute(attributeKey, value);
                if (attribute == null) {
                    bdfUserPrefsEditor.removeAttribute(attributeKey);
                } else {
                    bdfUserPrefsEditor.putAttribute(attribute);
                }
            }
        }
        String prefix = transformationKey + "/";
        for (String paramName : this.requestHandler.getParameterNameSet()) {
            if (!paramName.startsWith(prefix)) continue;
            String extension = paramName.substring(prefix.length());
            String value2 = this.requestHandler.getTrimedParameter(paramName);
            AttributeKey attributeKey = BdfUserSpace.toStreamTemplateAttributeKey(transformationKey, extension);
            if (value2.equals("_default")) {
                bdfUserPrefsEditor.removeAttribute(attributeKey);
                continue;
            }
            Attribute attribute = AttributeBuilder.toAttribute(attributeKey, value2);
            if (attribute == null) {
                bdfUserPrefsEditor.removeAttribute(attributeKey);
                continue;
            }
            bdfUserPrefsEditor.putAttribute(attribute);
        }
    }
}

