/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurStatusCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurStatus";
    public static final String COMMANDKEY = "_ SPH-05";
    public static final String STATUS_PARAMNAME = "status";
    private Redacteur redacteur;
    private String newStatus;

    public RedacteurStatusCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            SphereEditor sphereEditor = session.getFichothequeEditor().getSphereEditor(this.redacteur.getSubsetKey());
            done = sphereEditor.setStatus(this.redacteur, this.newStatus);
        }
        this.putResultObject("obj.sphere", this.redacteur.getSphere());
        this.putResultObject("obj.redacteur", this.redacteur);
        if (done) {
            this.setDone("_ done.sphere.redacteurstatus", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        this.checkSubsetAdmin(this.redacteur.getSphere());
        try {
            this.newStatus = FichothequeConstants.checkRedacteurStatus(this.getMandatory(STATUS_PARAMNAME));
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(STATUS_PARAMNAME, this.newStatus);
        }
        PermissionSummary redacteurPermissionSummary = PermissionSummaryBuilder.build(this.bdfServer.getPermissionManager(), this.redacteur);
        if (redacteurPermissionSummary.isSubsetAdmin(this.redacteur.getSubsetKey())) {
            throw BdfErrors.error("_ error.unsupported.inactiveadmin");
        }
    }
}

