/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.fichotheque.tools.parsers.FicheItemParser;
import net.fichotheque.tools.sphere.RedacteurStats;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.TypoOptions;

public class RedacteurReplaceCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurReplace";
    public static final String COMMANDKEY = "_ SPH-07";
    public static final String REPLACETYPE_PARAMNAME = "replacetype";
    public static final String OTHER_REPLACETYPE_PARAMVALUE = "other";
    public static final String LITTERAL_REPLACETYPE_PARAMVALUE = "litteral";
    public static final String OTHER_PARAMNAME = "other";
    public static final String LITTERAL_PARAMNAME = "litteral";
    private Redacteur redacteur;
    private boolean otherRedac = false;
    private Redacteur otherRedacteur = null;
    private FicheItem ficheItem = null;

    public RedacteurReplaceCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        RedacteurStats redacteurStats = new RedacteurStats(this.redacteur);
        int count = redacteurStats.getFicheCount();
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            PersonItem oldFicheItem = new PersonItem(this.redacteur.getGlobalId());
            FicheItem newFicheItem = this.otherRedacteur != null ? new PersonItem(this.otherRedacteur.getGlobalId()) : this.ficheItem;
            List<RedacteurStats.ByCorpusStats> byCorpusStatsList = redacteurStats.getByCorpusStatsList();
            for (RedacteurStats.ByCorpusStats byCorpusStats : byCorpusStatsList) {
                Corpus corpus = byCorpusStats.getCorpus();
                CorpusEditor corpusEditor = session.getFichothequeEditor().getCorpusEditor(corpus);
                List<RedacteurStats.ByFicheStats> list = byCorpusStats.getByFicheStatsList();
                CorpusUtils.FieldSelection fieldSelection = CorpusUtils.getPersonneFieldSelection(corpus);
                FieldGenerationEngine engine = BdfCommandUtils.buildEngine(this, corpus);
                for (RedacteurStats.ByFicheStats byFicheStats : list) {
                    Fiche fiche;
                    boolean done;
                    int id = byFicheStats.getId();
                    FicheMeta ficheMeta = corpus.getFicheMetaById(id);
                    if (ficheMeta == null || !(done = CorpusUtils.replaceInField(fiche = corpus.getFiche(ficheMeta), fieldSelection, oldFicheItem, newFicheItem))) continue;
                    CorpusTools.saveFiche(corpusEditor, ficheMeta, fiche, engine, false);
                }
            }
        }
        this.setDone("_ done.sphere.redacteurreplace", count);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        String type = this.getMandatory(REPLACETYPE_PARAMNAME);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        try {
            this.otherRedac = RedacteurReplaceCommand.replaceTypeToBoolean(type);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(REPLACETYPE_PARAMNAME, type);
        }
        if (this.otherRedac) {
            String otherString = this.getMandatory("other");
            if ((otherString = otherString.trim()).length() == 0) {
                throw BdfErrors.error("_ error.empty.input");
            }
            try {
                this.otherRedacteur = this.bdfServer.getFichothequeQuestioner().getRedacteurByLogin(otherString, this.redacteur.getSubsetKey());
            }
            catch (UserLoginException e) {
                throw BdfErrors.error("_ error.unknown.redacteur", otherString);
            }
        }
        String litteralString = this.getMandatory("litteral");
        if ((litteralString = litteralString.trim()).length() == 0) {
            throw BdfErrors.error("_ error.empty.input");
        }
        TypoOptions typoOptions = BdfUserUtils.getTypoOptions(this.bdfUser);
        try {
            this.ficheItem = FicheItemParser.parsePerson(litteralString, typoOptions);
        }
        catch (ParseException pe) {
            this.ficheItem = FicheItemParser.parseItem(litteralString, typoOptions);
        }
    }

    public static boolean replaceTypeToBoolean(String replaceTypeValue) {
        if (replaceTypeValue.equals("other")) {
            return true;
        }
        if (replaceTypeValue.equals("litteral")) {
            return false;
        }
        throw new IllegalArgumentException("replaceTypeValue = " + replaceTypeValue);
    }
}

