/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.session.SessionObserver;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurRemove";
    public static final String COMMANDKEY = "_ SPH-06";
    private Redacteur redacteur;

    public RedacteurRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        String redacteurString = this.redacteur.getBracketStyle();
        Sphere sphere = this.redacteur.getSphere();
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            session.getFichothequeEditor().getSphereEditor(sphere.getSubsetKey()).removeRedacteur(this.redacteur);
        }
        this.putResultObject("obj.sphere", sphere);
        this.setDone("_ done.sphere.redacteurremove", redacteurString);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        this.checkSubsetAdmin(this.redacteur.getSphere());
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!this.isRemoveable(this.bdfServer.getPermissionManager(), this.redacteur)) {
            throw BdfErrors.error("_ error.notremoveable.redacteur", this.redacteur.getBracketStyle());
        }
        if (this.isRedacteurInSession(this.redacteur)) {
            throw BdfErrors.error("_ error.unsupported.redacteurinsesssion", this.redacteur.getBracketStyle());
        }
    }

    private boolean isRemoveable(PermissionManager permissionManager, Redacteur redacteur) {
        if (!this.bdfServer.getFichotheque().isRemoveable(redacteur)) {
            return false;
        }
        return !permissionManager.isAdmin(redacteur) || permissionManager.getAdminRedacteurList().size() != 1;
    }

    private boolean isRedacteurInSession(Redacteur redacteur) {
        SessionObserver sessionObserver = (SessionObserver)this.bdfServer.getContextObject("sessionObserver");
        BdfUser[] array = sessionObserver.getCurrentBdfUserArray();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!BdfUserUtils.isSame(this.bdfUser, redacteur)) continue;
            return true;
        }
        return false;
    }
}

