/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.tools.selection.SelectionDefBuilder;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;

public class SelectionDefChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SelectionDefChange";
    public static final String COMMANDKEY = "_ EXP-03";
    public static final String QUERY_XML_PARAMNAME = "query_xml";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private SelectionDef selectionDef;

    public SelectionDefChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SelectionManager selectionManager = this.bdfServer.getSelectionManager();
        selectionManager.putSelectionDef(this.selectionDef);
        this.putResultObject("obj.selectiondef", this.selectionDef);
        this.setDone("_ done.selection.selectiondefchange", this.selectionDef.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        SelectionDef currentSelectionDef = this.requestHandler.getMandatorySelectionDef();
        SelectionDefBuilder selectionDefBuilder = SelectionDefBuilder.init(currentSelectionDef.getName(), currentSelectionDef.getAttributes());
        BdfCommandUtils.parseQueries(this.fichotheque, this.getMandatory(QUERY_XML_PARAMNAME), selectionDefBuilder.getFichothequeQueriesBuilder());
        LabelChange labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        for (Label label : labelChange.getChangedLabels()) {
            selectionDefBuilder.putLabel(label);
        }
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            selectionDefBuilder.getAttributesBuilder().changeAttributes(AttributeParser.parse(attributes));
        }
        this.selectionDef = selectionDefBuilder.toSelectionDef();
    }
}

