/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class TemplateBinaryUpdateCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateBinaryUpdateCommand";
    public static final String COMMANDKEY = "_ EXP-36";
    public static final String FILE_PARAMNAME = "file";
    private TemplateKey templateKey;
    private String path;

    public TemplateBinaryUpdateCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter(FILE_PARAMNAME);
        }
        if (fileValue.length() < 2L) {
            fileValue.free();
            throw BdfErrors.error("_ error.empty.file");
        }
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        try (InputStream is = fileValue.getInputStream();){
            TemplateDescription templateDescription = this.bdfServer.getTransformationManager().putTemplateContent(this.templateKey, this.path, is, editOrigin);
            if (templateDescription != null) {
                this.putResultObject("obj.templatedescription", templateDescription);
                this.putResultObject("obj.templatecontentdescription", templateDescription.getTemplateContentDescription(this.path));
                this.setDone("_ done.exportation.templatebinaryupdate", new Object[0]);
            }
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.templatecontent_io", ioe.getMessage());
        }
        finally {
            fileValue.free();
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription templateDescription = this.requestHandler.getMandatoryTemplateDescription();
        TemplateContentDescription templateContentDescription = this.requestHandler.getMandatoryTemplateContentDescription(templateDescription);
        this.templateKey = templateContentDescription.getTemplateKey();
        this.path = templateContentDescription.getPath();
    }
}

