/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.commands.exportation.AbstractDefChangeCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.exportation.sql.SqlExportDef;
import net.fichotheque.tools.exportation.sql.SqlExportDefBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class SqlExportChangeCommand
extends AbstractDefChangeCommand {
    public static final String COMMANDNAME = "SqlExportChange";
    public static final String COMMANDKEY = "_ EXP-43";
    public static final String CUSTOMCLASSNAME_PARAMNAME = "customclassname";
    public static final String PARAMS_PARAMNAME = "params";
    public static final String FILENAME_PARAMNAME = "filename";
    public static final String TABLEEXPORTNAME_PARAMNAME = "tableexportname";
    public static final String POSTCOMMAND_PARAMNAME = "postcommand";
    private SqlExportDef sqlExportDef;

    public SqlExportChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SqlExportManager sqlExportManager = this.bdfServer.getSqlExportManager();
        sqlExportManager.putSqlExportDef(this.sqlExportDef);
        this.putResultObject("obj.sqlexportdef", this.sqlExportDef);
        this.setDone("_ done.exportation.sqlexportchange", this.sqlExportDef.getName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String[] tokens;
        this.checkFichothequeAdmin();
        SqlExportDef currentSqlExportDef = this.requestHandler.getMandatorySqlExportDef();
        String sqlExportClassName = this.getMandatory(CUSTOMCLASSNAME_PARAMNAME);
        String tableExportName = this.getMandatory(TABLEEXPORTNAME_PARAMNAME);
        String postCommand = this.getMandatory(POSTCOMMAND_PARAMNAME);
        String fileName = this.getMandatory(FILENAME_PARAMNAME);
        String params = this.getMandatory(PARAMS_PARAMNAME);
        SqlExportDefBuilder sqlExportDefBuilder = SqlExportDefBuilder.init(currentSqlExportDef.getName(), currentSqlExportDef.getAttributes()).setSqlExportClassName(sqlExportClassName).setPostCommand(postCommand).setTableExportName(tableExportName).setTargetName(this.getTargetName()).setTargetPath(this.getTargetPath());
        try {
            sqlExportDefBuilder.setFileName(fileName);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.filename", fileName);
        }
        for (String token : tokens = StringUtils.getLineTokens(params, (short)2)) {
            String name;
            int idx = token.indexOf(61);
            if (idx == -1 || (name = token.substring(0, idx).trim()).length() <= 0) continue;
            sqlExportDefBuilder.addParam(name, token.substring(idx + 1));
        }
        this.checkSelectionOptions(sqlExportDefBuilder.getSelectionOptionsBuilder());
        this.checkDefBuilder(sqlExportDefBuilder);
        this.sqlExportDef = sqlExportDefBuilder.toSqlExportDef();
    }
}

