/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.AccessManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.exportation.access.AccessDef;
import net.fichotheque.tools.exportation.access.AccessDefBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class AccessCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AccessCreation";
    public static final String COMMANDKEY = "_ EXP-61";
    public static final String NEWACCESS_PARAMNAME = "newaccess";
    private String newAccessName;

    public AccessCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        AccessManager accessManager = this.bdfServer.getAccessManager();
        AccessDef accessDef = AccessDefBuilder.init(this.newAccessName).toAccessDef();
        accessManager.putAccessDef(accessDef);
        this.putResultObject("obj.accessdef", accessDef);
        this.setDone("_ done.exportation.accesscreation", this.newAccessName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newAccessName = this.getMandatory(NEWACCESS_PARAMNAME);
        if (this.newAccessName.length() == 0) {
            throw BdfErrors.error("_ error.empty.accessname");
        }
        AccessManager accessManager = this.bdfServer.getAccessManager();
        AccessDef accessDef = accessManager.getAccessDef(this.newAccessName);
        if (accessDef != null) {
            throw BdfErrors.error("_ error.existing.access", this.newAccessName);
        }
        if (!StringUtils.isTechnicalName(this.newAccessName, true)) {
            throw BdfErrors.error("_ error.wrong.accessname", this.newAccessName);
        }
    }
}

