/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.edition;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.EditionEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.ExistingIdException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FicheCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheCreation";
    private Corpus corpus;

    public FicheCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheMeta ficheMeta;
        try (EditSession session = this.startEditSession("edition", COMMANDNAME);){
            CorpusEditor corpusEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus);
            try {
                ficheMeta = corpusEditor.createFiche(-1);
            }
            catch (ExistingIdException eii) {
                throw new ImplementationException(eii);
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException(nmie);
            }
            corpusEditor.setDate(ficheMeta, FuzzyDate.current(), false);
            EditionEngine.replace(session, this, this.requestHandler.getRequestMap(), ficheMeta);
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.putResultObject("obj.fichemeta", ficheMeta);
        this.setDone("_ done.edition.fichecreation", CorpusMetadataUtils.getFicheTitle(ficheMeta, this.bdfUser.getWorkingLang(), this.bdfUser.getFormatLocale()));
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        if (this.corpus.getMasterSubset() != null) {
            throw BdfErrors.internalError("corpus.getMasterSubset() != null");
        }
        this.getPermissionChecker().checkFicheCreate(this.corpus);
    }
}

