/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.ui.components.CommentUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.DataUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.FieldUiBuilder;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UiComponentAttributesCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UiComponentAttributes";
    public static final String COMMANDKEY = "_ CRP-30";
    public static final String ATTRIBUTES_PARAMSUFFIX = "|attributes";
    private Corpus corpus;
    private UiComponents uiComponents;
    private List<UiComponent> uiComponentList;

    public UiComponentAttributesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done = false;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            for (UiComponent componentUi : this.uiComponentList) {
                boolean stepDone = bdfServerEditor.putComponentUi(this.uiComponents, componentUi);
                if (!stepDone) continue;
                done = true;
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.global.attributechange", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        this.uiComponentList = new ArrayList<UiComponent>();
        HashSet<String> existingSet = new HashSet<String>();
        for (UiComponent uiComponent : this.uiComponents.getUiComponentList()) {
            UiComponent newUiComponent;
            String name = uiComponent.getName();
            if (existingSet.contains(name)) continue;
            existingSet.add(name);
            String attributes = this.requestHandler.getTrimedParameter(name + ATTRIBUTES_PARAMSUFFIX);
            if (attributes.isEmpty() || (newUiComponent = this.getNewComponent(uiComponent, attributes)) == null) continue;
            this.uiComponentList.add(newUiComponent);
        }
    }

    private UiComponent getNewComponent(UiComponent uiComponent, String text) {
        if (uiComponent instanceof FieldUi) {
            FieldUiBuilder fieldUiBuilder = FieldUiBuilder.derive((FieldUi)uiComponent);
            AttributeParser.parse(fieldUiBuilder.getAttributeChangeBuilder(), text);
            return fieldUiBuilder.toFieldUi();
        }
        if (uiComponent instanceof IncludeUi) {
            IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.init((IncludeUi)uiComponent);
            AttributeParser.parse(includeUiBuilder.getAttributeChangeBuilder(), text);
            return includeUiBuilder.toIncludeUi();
        }
        if (uiComponent instanceof CommentUi) {
            CommentUiBuilder commentUiBuilder = CommentUiBuilder.init(this.bdfServer.getUiManager().getHtmlCleaner(), (CommentUi)uiComponent);
            AttributeParser.parse(commentUiBuilder.getAttributeChangeBuilder(), text);
            return commentUiBuilder.toCommentUi();
        }
        if (uiComponent instanceof DataUi) {
            DataUiBuilder dataUiBuilder = DataUiBuilder.init((DataUi)uiComponent);
            AttributeParser.parse(dataUiBuilder.getAttributeChangeBuilder(), text);
            return dataUiBuilder.toDataUi();
        }
        return null;
    }
}

