/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.tools.FichothequeTools;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class FicheRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheRemove";
    public static final String COMMANDKEY = "_ CRP-11";
    public static final String DISCARDTEXT_PARAMNAME = "discardtext";
    private FicheMeta ficheMeta;
    private Attribute discardAttribute;

    public FicheRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Corpus corpus = this.ficheMeta.getCorpus();
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            fichothequeEditor.putAttribute(this.ficheMeta, this.discardAttribute);
            int ficheid = this.ficheMeta.getId();
            for (Corpus satelliteCorpus : this.ficheMeta.getCorpus().getSatelliteCorpusList()) {
                FicheMeta satelliteFicheMeta = satelliteCorpus.getFicheMetaById(ficheid);
                if (satelliteFicheMeta == null) continue;
                fichothequeEditor.putAttribute(satelliteFicheMeta, this.discardAttribute);
            }
            fichothequeEditor.saveChanges();
            FichothequeTools.remove(fichothequeEditor, this.ficheMeta);
        }
        this.putResultObject("obj.corpus", corpus);
        this.setDone("_ done.corpus.ficheremove", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.ficheMeta = this.requestHandler.getMandatoryFicheMeta();
        this.checkSubsetAdmin(this.ficheMeta.getCorpus());
        String discardText = this.getMandatory(DISCARDTEXT_PARAMNAME);
        String[] tokens = StringUtils.getLineTokens(discardText, (short)2);
        if (tokens.length == 0) {
            throw BdfErrors.error("_ error.empty.discardtext_remove");
        }
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        AttributeBuilder builder = new AttributeBuilder(BdfSpace.DISCARDTEXT_KEY);
        for (String token : tokens) {
            builder.addValue(token);
        }
        this.discardAttribute = builder.toAttribute();
    }
}

