/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CorpusAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CorpusAttributeChange";
    public static final String COMMANDKEY = "_ CRP-03";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Corpus corpus;
    private AttributeChange attributeChange;

    public CorpusAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.corpus.getCorpusMetadata(), this.attributeChange);
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.bdfServer.getTransformationManager().clearDistTransformer();
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

