/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CommentRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CommentRemove";
    public static final String COMMANDKEY = "_ CRP-17";
    public static final String NAME_PARAMNAME = "name";
    private Corpus corpus;
    private UiComponents uiComponents;
    private String name;

    public CommentRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = session.getBdfServerEditor().removeComponentUi(this.uiComponents, CommentUi.toComponentName(this.name));
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.commentremove", this.name);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        this.name = this.getMandatory(NAME_PARAMNAME);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        if (!this.uiComponents.contains(CommentUi.toComponentName(this.name))) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, this.name);
        }
    }
}

