/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.externalscript.ExternalScript;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ExternalScriptRunCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ExternalScriptRunCommand";
    public static final String NAME_PARAMNAME = "name";
    private ExternalScript externalScript;

    public ExternalScriptRunCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try {
            this.externalScript.exec();
            this.setDone("_ done.configuration.externalscriptrun", this.externalScript.getName());
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.script_io", this.externalScript.getName(), ioe.getLocalizedMessage());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String name = this.getMandatory(NAME_PARAMNAME);
        this.externalScript = this.bdfServer.getExternalScriptManager().getExternalScript(name);
        if (this.externalScript == null) {
            throw BdfErrors.error("_ error.unknown.externalscript", name);
        }
    }
}

