/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.IconScanEngine;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;

public class CustomIconUploadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "LogoUpload";
    public static final String COMMANDKEY = "_ CNF-09";
    public static final String FILE_PARAMNAME = "file";
    public static final String REL_PARAMNAME = "rel";
    public static final String SIZES_PARAMNAME = "sizes";
    public static final String ICON_REL_PARAMVALUE = "icon";
    public static final String TOUCH_REL_PARAMVALUE = "touch";
    public static final String SHORTCUT_REL_PARAMVALUE = "shortcut";
    private String basename;

    public CustomIconUploadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter(FILE_PARAMNAME);
        }
        if (fileValue.length() < 2L) {
            fileValue.free();
            throw BdfErrors.error("_ error.empty.file");
        }
        String resourceName = this.checkExtension(fileValue.getName());
        if (resourceName == null) {
            fileValue.free();
            throw BdfErrors.error("_ error.empty.extension", fileValue.getName());
        }
        RelativePath relativePath = IconScanEngine.ICON_FOLDER.buildChild(resourceName);
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("configuration", COMMANDNAME);
        try (InputStream is = fileValue.getInputStream();){
            StorageUtils.saveResource(this.bdfServer, relativePath, is, editOrigin);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        finally {
            fileValue.free();
        }
        this.putResultObject("obj.relativepath", relativePath);
        this.setDone("_ done.configuration.customiconupload", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String prefix = CustomIconUploadCommand.getPrefix(this.getMandatory(REL_PARAMNAME));
        String sizes = this.getMandatory(SIZES_PARAMNAME).trim();
        sizes = sizes.replace(" ", "_");
        String name = prefix + sizes;
        if (!ResourceUtils.isValidResourceName(name + ".png")) {
            throw BdfErrors.error("_ error.wrong.sizes", sizes);
        }
        this.basename = name;
    }

    private String checkExtension(String fileName) {
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        String extension = fileName.substring(idx + 1).toLowerCase();
        if (extension.isEmpty()) {
            return null;
        }
        String result = this.basename + "." + extension;
        if (!ResourceUtils.isValidResourceName(result)) {
            return null;
        }
        return result;
    }

    private static String getPrefix(String rel) throws ErrorMessageException {
        switch (rel) {
            case "icon": {
                return "icon-";
            }
            case "touch": {
                return "touchicon-";
            }
            case "shortcut": {
                return "shortcuticon-";
            }
        }
        throw BdfErrors.unknownParameterValue(REL_PARAMNAME, rel);
    }
}

