/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.commands.configuration.CustomIconUploadCommand;
import fr.exemole.bdfserver.commands.configuration.ExtensionActivationCommand;
import fr.exemole.bdfserver.commands.configuration.ExternalScriptRunCommand;
import fr.exemole.bdfserver.commands.configuration.FichothequeAttributeChangeCommand;
import fr.exemole.bdfserver.commands.configuration.FichothequePhrasesCommand;
import fr.exemole.bdfserver.commands.configuration.GroupChangeCommand;
import fr.exemole.bdfserver.commands.configuration.GroupCreationCommand;
import fr.exemole.bdfserver.commands.configuration.GroupRemoveCommand;
import fr.exemole.bdfserver.commands.configuration.IdentificationCommand;
import fr.exemole.bdfserver.commands.configuration.LangConfigCommand;
import fr.exemole.bdfserver.commands.configuration.OdtLogoChangeCommand;
import fr.exemole.bdfserver.commands.configuration.SubsetTreeCommand;
import fr.exemole.bdfserver.commands.configuration.UserAllowChangeCommand;
import net.mapeadores.util.request.RequestMap;

public class ConfigurationCommandFactory {
    private ConfigurationCommandFactory() {
    }

    public static BdfCommand getBdfCommand(BdfServer bdfServer, RequestMap requestMap, String commandName) {
        switch (commandName) {
            case "GroupChange": {
                return new GroupChangeCommand(bdfServer, requestMap);
            }
            case "GroupCreation": {
                return new GroupCreationCommand(bdfServer, requestMap);
            }
            case "GroupRemove": {
                return new GroupRemoveCommand(bdfServer, requestMap);
            }
            case "Identification": {
                return new IdentificationCommand(bdfServer, requestMap);
            }
            case "FichothequePhrases": {
                return new FichothequePhrasesCommand(bdfServer, requestMap);
            }
            case "LangConfig": {
                return new LangConfigCommand(bdfServer, requestMap);
            }
            case "SubsetTree": {
                return new SubsetTreeCommand(bdfServer, requestMap);
            }
            case "UserAllowChange": {
                return new UserAllowChangeCommand(bdfServer, requestMap);
            }
            case "FichothequeAttributeChange": {
                return new FichothequeAttributeChangeCommand(bdfServer, requestMap);
            }
            case "ExtensionActivation": {
                return new ExtensionActivationCommand(bdfServer, requestMap);
            }
            case "ExternalScriptRunCommand": {
                return new ExternalScriptRunCommand(bdfServer, requestMap);
            }
            case "LogoUpload": {
                return new CustomIconUploadCommand(bdfServer, requestMap);
            }
            case "OdtLogoChange": {
                return new OdtLogoChangeCommand(bdfServer, requestMap);
            }
        }
        return null;
    }
}

