/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.album.AlbumCommandUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import net.fichotheque.album.Album;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.images.ImagesUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class IllustrationFileUploadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IllustrationFileUpload";
    public static final String COMMANDKEY = "_ ALB-07";
    public static final String FILE_PARAMNAME = "file";
    private Album album;

    public IllustrationFileUploadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter(FILE_PARAMNAME);
        }
        File tmpFile = this.saveFile(fileValue);
        this.setDone("_ done.album.illustrationfileupload", new Object[0]);
        this.putResultObject("obj.tmpfile", tmpFile);
        this.putResultObject("obj.album", this.album);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.album = this.requestHandler.getMandatoryAlbum();
    }

    private File saveFile(FileValue fileValue) throws ErrorMessageException {
        long length = fileValue.length();
        if (length < 2L) {
            fileValue.free();
            throw BdfErrors.error("_ error.empty.file");
        }
        String extension = AlbumUtils.checkExtension(fileValue.getName());
        if (extension == null) {
            fileValue.free();
            throw BdfErrors.error("_ error.wrong.imageextension");
        }
        try {
            File file;
            block13: {
                InputStream is = fileValue.getInputStream();
                try {
                    file = IllustrationFileUploadCommand.saveFile(this.bdfServer, is, extension, this.album);
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw BdfErrors.ioException(ioe);
                    }
                }
                is.close();
            }
            return file;
        }
        finally {
            fileValue.free();
        }
    }

    public static File saveFile(BdfServer bdfServer, InputStream inputStream, String extension, Album album) throws IOException, ErrorMessageException {
        File tmpFile;
        if (AlbumUtils.isPngConvertible(extension)) {
            extension = "png";
            tmpFile = AlbumCommandUtils.getTmpFile(bdfServer, "png");
            BufferedImage srcImg = ImagesUtils.read(inputStream);
            ImagesUtils.write(srcImg, "png", tmpFile);
        } else {
            byte[] array = IOUtils.toByteArray(inputStream);
            try {
                BufferedImage bufferedImage = ImagesUtils.read(new ByteArrayInputStream(array));
            }
            catch (IOException ioe) {
                if (ioe instanceof IIOException) {
                    throw new ErrorMessageException("_ error.unsupported.imagetype");
                }
                throw new ErrorMessageException("_ error.exception.io", ioe.getMessage());
            }
            tmpFile = AlbumCommandUtils.getTmpFile(bdfServer, extension);
            try (FileOutputStream os = new FileOutputStream(tmpFile);){
                IOUtils.copy((InputStream)new ByteArrayInputStream(array), (OutputStream)os);
            }
        }
        AlbumCommandUtils.minimizeTmpFile(tmpFile, album);
        return tmpFile;
    }
}

