/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.metadata.AlbumDim;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumDimRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AlbumDimRemove";
    public static final String COMMANDKEY = "_ ALB-05";
    private AlbumDim albumDim;

    public AlbumDimRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        String name = this.albumDim.getName();
        Album album = this.albumDim.getAlbumMetadata().getAlbum();
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            AlbumEditor albumEditor = session.getFichothequeEditor().getAlbumEditor(album);
            albumEditor.getAlbumMetadataEditor().removeAlbumDim(this.albumDim);
        }
        this.setDone("_ done.album.albumdimremove", name);
        this.putResultObject("obj.album", album);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.albumDim = this.requestHandler.getMandatoryAlbumDim();
        this.checkSubsetAdmin(this.albumDim.getAlbumMetadata().getAlbum());
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }
}

