/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.File;
import java.io.IOException;
import net.fichotheque.album.Album;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.images.ImageResizing;
import net.mapeadores.util.logging.ErrorMessageException;

public class AlbumCommandUtils {
    public static final String ORIGINAL_TMPFILENAME = "_ORIGINAL";

    private AlbumCommandUtils() {
    }

    public static void minimizeTmpFile(File tmpFile, Album album) throws IOException, ErrorMessageException {
        ResizeInfo resizeInfo = album.getAlbumMetadata().getResizeInfo("_mini");
        String fileName = tmpFile.getName();
        String extension = AlbumUtils.getExtension(fileName);
        File miniFile = new File(tmpFile.getParentFile(), "mini-" + fileName);
        ImageResizing.resize(tmpFile, miniFile, resizeInfo, extension);
    }

    public static File getTmpFile(BdfServer bdfServer, String extension) {
        BdfServer bdfServer2 = bdfServer;
        synchronized (bdfServer2) {
            File tmpDirectory = ConfigurationUtils.getTmpDirectory(bdfServer, true);
            String number = Long.toHexString(System.currentTimeMillis());
            File f = new File(tmpDirectory, "img-" + number + "." + extension);
            if (!f.exists()) {
                return f;
            }
            int p = 1;
            while (true) {
                if (!(f = new File(tmpDirectory, "img-" + number + "_" + p + "." + extension)).exists()) {
                    return f;
                }
                ++p;
            }
        }
    }
}

