/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.apps.AppConfUtils;
import fr.exemole.bdfserver.tools.apps.StarterEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;

public class NewAppCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "NewApp";
    public static final String COMMANDKEY = "_ ADM-15";
    public static final String NEWAPPNAME_PARAMNAME = "newappname";
    public static final String STARTER_PARAMNAME = "starter";
    private String newAppName;
    private String starterName;

    public NewAppCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("administration", COMMANDNAME);
        try {
            StarterEngine.copy(this.bdfServer, editOrigin, this.newAppName, this.starterName);
            this.setDone("_ done.administration.newapp", this.newAppName);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        catch (ParseException pe) {
            throw new ShouldNotOccurException("test done before", pe);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newAppName = this.getMandatory(NEWAPPNAME_PARAMNAME);
        this.starterName = this.requestHandler.getTrimedParameter(STARTER_PARAMNAME);
        if (this.starterName.isEmpty()) {
            this.starterName = "minimal";
        }
        try {
            StringUtils.checkTechnicalName(this.newAppName, true);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.appname", this.newAppName);
        }
        RelativePath appIniPath = StorageUtils.buildAppResourcePath(this.newAppName, "app.ini");
        if (this.bdfServer.getResourceStorages().containsResource(appIniPath)) {
            throw BdfErrors.error("_ error.existing.app", this.newAppName);
        }
        if (!AppConfUtils.isAvailableStarter(this.starterName)) {
            throw BdfErrors.error("_ error.unknwon.starter", this.starterName);
        }
    }
}

