/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class BackupDeleteCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "BackupDelete";
    public static final String COMMANDKEY = "_ ADM-02";
    public static final String BACKUP_PARAMNAME = "backup";
    private File backupFile;

    public BackupDeleteCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done = this.backupFile.delete();
        if (done) {
            this.setDone("_ done.administration.backupdelete", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String backupName = this.getMandatory(BACKUP_PARAMNAME);
        if (!BackupDeleteCommand.testName(backupName)) {
            throw BdfErrors.wrongParameterValue(BACKUP_PARAMNAME, backupName);
        }
        File backupDirectory = ConfigurationUtils.getBackupDirectory(this.bdfServer);
        this.backupFile = new File(backupDirectory, backupName);
    }

    private static boolean testName(String name) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char carac = name.charAt(i);
            boolean ok = false;
            switch (carac) {
                case '-': 
                case '.': 
                case '_': {
                    ok = true;
                }
            }
            if (carac >= '0' && carac <= '9') {
                ok = true;
            } else if (carac >= 'a' && carac <= 'z') {
                ok = true;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }
}

