/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api;

public interface BdfServerConstants {
    public static final String SESSIONOBSERVER_CONTEXTOBJECT = "sessionObserver";
    public static final String SMTPMANAGER_CONTEXTOBJECT = "smtpManager";
    public static final String FICHOTHEQUESHARING_CONTEXTOBJECT = "fichothequeSharing";
    public static final String BDFSERVER_CONTEXTOBJECT = "bdfServer";
    public static final String MIMETYPERESOLVER_CONTEXTOBJECT = "mimeTypeResolver";
    public static final String SPHERESUPERVISOR_CONTEXTOBJECT = "sphereSupervisor";
    public static final String VAR_STORAGE = "var";
    public static final String ETC_STORAGE = "etc";
    public static final String DIST_STORAGE = "dist";
    public static final String DEFAULT_STATUS = "default";
    public static final String MANDATORY_STATUS = "mandatory";
    public static final String OPTIONAL_STATUS = "optional";
    public static final String OBSOLETE_STATUS = "obsolete";
    public static final String DEFAULTVALUE_OPTION = "defaultValue";
    public static final String INCLUDEVARIANT_OPTION = "includeVariant";
    public static final String INPUTROWS_OPTION = "inputRows";
    public static final String INPUTWIDTH_OPTION = "inputWidth";
    public static final String INPUTTYPE_OPTION = "inputType";
    public static final String WIDTH_SMALL = "small";
    public static final String WIDTH_MEDIUM = "medium";
    public static final String WIDTH_LARGE = "large";
    public static final String INPUT_TEXT = "text";
    public static final String INPUT_SELECT = "select";
    public static final String INPUT_CHECK = "check";
    public static final String INPUT_RADIO = "radio";
    public static final String INPUT_NOTEDITABLE = "noteditable";
    public static final String INPUT_HIDDEN = "hidden";
    public static final String INPUT_FICHESTYLE = "fichestyle";
    public static final String DATEINPUTS_ISO = "iso";
    public static final String DATEINPUTS_INVERSE = "inv";
    public static final String DATEINPUTS_USA = "usa";

    public static String checkValidStatus(String status) {
        if (status == null || status.isEmpty()) {
            return DEFAULT_STATUS;
        }
        switch (status) {
            case "default": {
                return DEFAULT_STATUS;
            }
            case "mandatory": {
                return MANDATORY_STATUS;
            }
            case "optional": {
                return OPTIONAL_STATUS;
            }
            case "obsolete": {
                return OBSOLETE_STATUS;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    public static String checkInputType(String inputType) {
        switch (inputType) {
            case "text": 
            case "suggestion": {
                return INPUT_TEXT;
            }
            case "select": {
                return INPUT_SELECT;
            }
            case "check": {
                return INPUT_CHECK;
            }
            case "radio": {
                return INPUT_RADIO;
            }
            case "noteditable": {
                return INPUT_NOTEDITABLE;
            }
            case "hidden": {
                return INPUT_HIDDEN;
            }
            case "fichestyle": {
                return INPUT_FICHESTYLE;
            }
        }
        throw new IllegalArgumentException("wrong value :" + inputType);
    }

    public static String checkWidth(String widthType) {
        switch (widthType) {
            case "small": {
                return WIDTH_SMALL;
            }
            case "medium": {
                return WIDTH_MEDIUM;
            }
            case "large": {
                return WIDTH_LARGE;
            }
        }
        try {
            int size = Integer.parseInt(widthType);
            if (size < 10) {
                return WIDTH_SMALL;
            }
            if (size < 50) {
                return WIDTH_MEDIUM;
            }
            return WIDTH_LARGE;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("wrong value : " + widthType);
        }
    }

    public static String checkDateInputsType(String dateinputsType) {
        switch (dateinputsType) {
            case "iso": {
                return DATEINPUTS_ISO;
            }
            case "inv": {
                return DATEINPUTS_INVERSE;
            }
            case "usa": {
                return DATEINPUTS_USA;
            }
        }
        throw new IllegalArgumentException("wrong value :" + dateinputsType);
    }
}

