/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils.instructions;

import fr.exemole.bdfext.utils.instructions.UtilsInstruction;
import fr.exemole.bdfext.utils.instructions.UtilsInstructionException;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Tie;

public class ListeLiage
extends UtilsInstruction {
    @Override
    public Object runInstruction() {
        String corpusName = (String)this.instructionMap.get("corpus");
        if (corpusName == null) {
            throw new UtilsInstructionException("corpus non d\u00e9fini");
        }
        Corpus corpus = this.fichotheque.getCorpus(corpusName);
        if (corpus == null) {
            return "Corpus inconnu : " + corpusName;
        }
        String idString = (String)this.instructionMap.get("id");
        if (idString == null) {
            throw new UtilsInstructionException("id non d\u00e9fini");
        }
        int id = -1;
        try {
            id = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            throw new UtilsInstructionException("id n'est pas un entier : " + idString);
        }
        FicheMeta ficheMeta = corpus.getFicheMetaById(id);
        if (ficheMeta == null) {
            return "Fiche inconnue : " + idString;
        }
        StringBuilder buf = new StringBuilder();
        for (Corpus other : this.fichotheque.getCorpusList()) {
            Junctions ficheJunctions = this.fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)other);
            String prefixe = other.getSubsetName() + "/";
            for (Junctions.Entry entry : ficheJunctions.getEntryList()) {
                FicheMeta otherFiche = (FicheMeta)entry.getSubsetItem();
                buf.append(prefixe);
                buf.append(otherFiche.getId());
                buf.append('<');
                boolean next = false;
                for (Tie tie : entry.getJunction().getTieList()) {
                    if (next) {
                        buf.append(',');
                    } else {
                        next = true;
                    }
                    String mode = tie.getMode();
                    if (!mode.isEmpty()) {
                        buf.append(mode);
                        buf.append('/');
                    }
                    buf.append(tie.getWeight());
                }
                buf.append('>');
                buf.append("; ");
            }
        }
        return buf.toString();
    }
}

