/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils;

import fr.exemole.bdfext.utils.instructions.ImportQr;
import fr.exemole.bdfext.utils.instructions.InsertionFiches;
import fr.exemole.bdfext.utils.instructions.ListeLiage;
import fr.exemole.bdfext.utils.instructions.Migration;
import fr.exemole.bdfext.utils.instructions.NettoyageSelection;
import fr.exemole.bdfext.utils.instructions.SelectionLiage;
import fr.exemole.bdfext.utils.instructions.UtilsInstruction;
import fr.exemole.bdfext.utils.instructions.UtilsInstructionException;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.Map;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;

public class UtilsBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private final Map<String, String> instructionMap;
    private final RequestMap requestMap;
    private final BdfServer bdfServer;

    public UtilsBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> instructionMap) {
        this.instructionMap = instructionMap;
        this.requestMap = requestMap;
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        Object result;
        if (!BdfUserUtils.isAdmin((BdfServer)this.bdfServer, (BdfUser)bdfUser)) {
            return null;
        }
        String instructionName = this.instructionMap.get("instruction");
        UtilsInstruction utilsInstruction = null;
        if (instructionName.equals("SelectionLiage")) {
            utilsInstruction = new SelectionLiage();
        }
        if (instructionName.equals("NettoyageSelection")) {
            utilsInstruction = new NettoyageSelection();
        }
        if (instructionName.equals("ListeLiage")) {
            utilsInstruction = new ListeLiage();
        }
        if (instructionName.equals("InsertionFiches")) {
            utilsInstruction = new InsertionFiches();
        }
        if (instructionName.equals("Migration")) {
            utilsInstruction = new Migration();
        }
        if (instructionName.equals("ImportQr")) {
            utilsInstruction = new ImportQr();
        }
        if (utilsInstruction == null) {
            return SimpleResponseHandler.init((String)("Instruction inconnue : " + instructionName));
        }
        utilsInstruction.setBdfParameters((BdfParameters)new DefaultBdfParameters(this.bdfServer, bdfUser));
        utilsInstruction.setRequestMap(this.requestMap);
        utilsInstruction.setInstructionMap(this.instructionMap);
        try {
            result = utilsInstruction.runInstruction();
        }
        catch (UtilsInstructionException uie) {
            return SimpleResponseHandler.init((String)("Exception : " + uie.getMessage()));
        }
        if (result == null) {
            return SimpleResponseHandler.init((String)("Instruction effectu\u00e9e : " + instructionName));
        }
        if (result instanceof String) {
            return SimpleResponseHandler.init((String)((String)result));
        }
        if (result instanceof ResponseHandler) {
            return (ResponseHandler)result;
        }
        if (result instanceof HtmlProducer) {
            return HtmlResponseHandler.init((HtmlProducer)((HtmlProducer)result));
        }
        if (result instanceof JsonProducer) {
            return JsonResponseHandler.build((JsonProducer)((JsonProducer)result), (RequestMap)this.requestMap);
        }
        return SimpleResponseHandler.init((String)("Classe inconnue : " + result.getClass().getName()));
    }
}

