/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.BanqueDetail;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.tools.Comparators;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mapeadores.util.date.RangeDateFilter;

public class BanqueDetailBuilder {
    private final Banque banque;
    private final RangeDateFilter dateFilter;
    private final List<Mouvement> mouvementList = new ArrayList<Mouvement>();
    private long debitReport = 0L;
    private long creditReport = 0L;

    public BanqueDetailBuilder(Banque banque, RangeDateFilter dateFilter) {
        this.banque = banque;
        this.dateFilter = dateFilter;
        long report = banque.getReportMoneyLong();
        if (report > 0L) {
            this.creditReport = report;
        } else {
            this.debitReport = -report;
        }
    }

    public boolean addMouvement(Mouvement mouvement) {
        if (this.dateFilter == null) {
            this.mouvementList.add(mouvement);
            return true;
        }
        int test = this.dateFilter.testInRange(mouvement.getDate());
        if (test == -1) {
            long montant = mouvement.getMontantMoneyLong();
            if (mouvement.isDebit()) {
                this.debitReport += montant;
            } else {
                this.creditReport += montant;
            }
            return true;
        }
        if (test == 0) {
            this.mouvementList.add(mouvement);
            return true;
        }
        return false;
    }

    public void sortByPiece() {
        Collections.sort(this.mouvementList, Comparators.MOUVEMENT_NUMEROPIECE);
    }

    public BanqueDetail toBanqueDetail() {
        List<Mouvement> finalMouvementList = CoreUtils.toMouvementList(this.mouvementList);
        return new InternalBanqueDetail(this.banque, this.dateFilter, finalMouvementList, this.debitReport, this.creditReport);
    }

    private static class InternalBanqueDetail
    implements BanqueDetail {
        private final Banque banque;
        private final RangeDateFilter dateFilter;
        private final List<Mouvement> mouvementList;
        private long debitReport = 0L;
        private long creditReport = 0L;

        private InternalBanqueDetail(Banque banque, RangeDateFilter dateFilter, List<Mouvement> mouvementList, long debitReport, long creditReport) {
            this.banque = banque;
            this.dateFilter = dateFilter;
            this.mouvementList = mouvementList;
            this.debitReport = debitReport;
            this.creditReport = creditReport;
        }

        @Override
        public Banque getBanque() {
            return this.banque;
        }

        @Override
        public RangeDateFilter getRangeDateIntegerFilter() {
            return this.dateFilter;
        }

        public List getMouvementList() {
            return this.mouvementList;
        }

        @Override
        public long getDebitReport() {
            return this.debitReport;
        }

        @Override
        public long getCreditReport() {
            return this.creditReport;
        }
    }
}

