/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeSpace;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenExportLogHandler;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenInfo;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.Compte;
import fr.exemole.bdfext.scarabe.api.comptagen.Journal;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenInfoBuilder;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenLigneBuilder;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenSortKey;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import fr.exemole.bdfext.scarabe.tools.core.BanquesBuilder;
import fr.exemole.bdfext.scarabe.tools.core.MouvementBuilder;
import fr.exemole.bdfext.scarabe.tools.cours.CoursManagerBuilder;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.date.DateFilter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyConversion;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;

public class ExportEngine {
    private final FichothequeQuestioner fichothequeQuestioner;
    private final BdfUser bdfUser;
    private final ScarabeContext scarabeContext;
    private final AliasHolder coreAliasHolder;
    private final AliasHolder comptagenAliasHolder;
    private final AliasHolder coursAliasHolder;
    private final Banques banques;
    private final ExtendedCurrency exportCurrency;
    private final ComptagenInfo comptagenInfo;
    private final DateFilter dateFilter;
    private final ComptagenExportLogHandler comptagenExportLogHandler;
    private final CorpusExportEngine depenseExport;
    private final CorpusExportEngine apportExport;
    private final CorpusExportEngine avanceExport;
    private final CoursManager coursManager;
    private final Thesaurus plancomptableThesaurus;
    private final Thesaurus comptetiersThesaurus;
    private final CorpusField factureField;
    private final Map<SubsetKey, ShortTitleInfo> infoMap = new HashMap<SubsetKey, ShortTitleInfo>();
    private final Map<String, Journal> journalMap = new HashMap<String, Journal>();
    private final Lang lang;

    private ExportEngine(BdfServer bdfServer, BdfUser bdfUser, ScarabeContext scarabeContext, ExtendedCurrency exportCurrency, DateFilter dateFilter, ComptagenExportLogHandler comptagenExportLogHandler) {
        this.fichothequeQuestioner = bdfServer.getFichothequeQuestioner();
        this.bdfUser = bdfUser;
        this.lang = bdfUser.getWorkingLang();
        this.dateFilter = dateFilter;
        this.scarabeContext = scarabeContext;
        this.coreAliasHolder = scarabeContext.getCoreAliasHolder();
        this.comptagenAliasHolder = scarabeContext.getComptagenAliasHolder();
        this.plancomptableThesaurus = this.comptagenAliasHolder.getThesaurus("plancomptable");
        this.comptetiersThesaurus = this.comptagenAliasHolder.getThesaurus("comptetiers");
        this.coursAliasHolder = scarabeContext.getCoursAliasHolder();
        this.exportCurrency = exportCurrency;
        this.comptagenInfo = ComptagenInfoBuilder.build(this.coreAliasHolder, this.comptagenAliasHolder, bdfUser.getWorkingLang());
        this.comptagenExportLogHandler = comptagenExportLogHandler;
        this.banques = BanquesBuilder.init(this.coreAliasHolder);
        this.depenseExport = new CorpusExportEngine("depense", comptagenExportLogHandler);
        this.apportExport = new CorpusExportEngine("apport", comptagenExportLogHandler);
        this.avanceExport = new CorpusExportEngine("avance", comptagenExportLogHandler);
        this.coursManager = this.coursAliasHolder != null ? CoursManagerBuilder.build(this.coursAliasHolder) : null;
        this.factureField = this.comptagenAliasHolder.getCorpusField("mouvement_facture");
    }

    public static List<ComptagenLigne> run(BdfServer bdfServer, BdfUser bdfUser, ScarabeContext scarabeContext, ExtendedCurrency exportCurrency, DateFilter dateIntegerFilter, boolean selection, ComptagenExportLogHandler comptagenExportLogHandler) {
        Corpus mouvementCorpus = scarabeContext.getCoreAliasHolder().getCorpus("mouvement");
        List mouvementList = selection ? CorpusUtils.getFicheMetaListByCorpus((Fiches)bdfUser.getSelectedFiches(), (Corpus)mouvementCorpus) : mouvementCorpus.getFicheMetaList();
        if (mouvementList.isEmpty()) {
            comptagenExportLogHandler.emptySelection();
            return Collections.emptyList();
        }
        ExportEngine exportEngine = new ExportEngine(bdfServer, bdfUser, scarabeContext, exportCurrency, dateIntegerFilter, comptagenExportLogHandler);
        return exportEngine.run(PointeurFactory.newFichePointeur((Corpus)mouvementCorpus), mouvementList);
    }

    private List<ComptagenLigne> run(FichePointeur mouvementPointeur, List<FicheMeta> mouvementList) {
        TreeMap map = new TreeMap();
        for (FicheMeta mouvementFicheMeta : mouvementList) {
            Item factureItem;
            int id = mouvementFicheMeta.getId();
            mouvementPointeur.setCurrentSubsetItem((SubsetItem)mouvementFicheMeta);
            Mouvement mouvement = MouvementBuilder.build(mouvementPointeur, this.scarabeContext, this.fichothequeQuestioner, this.banques, null);
            if (mouvement.hasError()) {
                this.comptagenExportLogHandler.excludeMouvement(id, mouvement.getErrorMessageList());
                continue;
            }
            if (!this.containsDate(mouvement.getDate())) continue;
            if (mouvement.getResteMoneyLong() != 0L) {
                this.comptagenExportLogHandler.excludeMouvement(id, "MONTANT_INCOHERENCE");
                continue;
            }
            ExtendedCurrency currency = mouvement.getCurrency();
            MoneyConversion moneyConversion = null;
            if (!currency.equals((Object)this.exportCurrency)) {
                if (this.coursManager == null) {
                    this.comptagenExportLogHandler.excludeMouvement(id, "COURSALIAS_NONE");
                    continue;
                }
                moneyConversion = this.coursManager.getMoneyConversion(mouvement.getDate(), this.exportCurrency, currency);
                if (moneyConversion == null) {
                    this.comptagenExportLogHandler.excludeMouvement(id, "MONEYCONVERSION_NONE");
                    continue;
                }
            }
            Journal journal = this.getJournal(mouvement);
            String codeBanque = mouvement.getBanque().getCodeBanque();
            Compte contrepartie = this.comptagenInfo.getContrepartie(codeBanque);
            if (contrepartie == null) {
                this.comptagenExportLogHandler.noContrepartie(codeBanque);
                continue;
            }
            String facture = "";
            if (this.factureField != null && (factureItem = (Item)mouvementPointeur.getValue(this.factureField)) != null) {
                facture = factureItem.getValue();
            }
            ArrayList tmpList = new ArrayList();
            this.depenseExport.addLignes(mouvement, journal, contrepartie, moneyConversion, tmpList, facture);
            this.apportExport.addLignes(mouvement, journal, contrepartie, moneyConversion, tmpList, facture);
            this.avanceExport.addLignes(mouvement, journal, contrepartie, moneyConversion, tmpList, facture);
            map.put(new ComptagenSortKey(mouvement.getNumeropiece(), mouvement.getDate(), id), tmpList);
        }
        ArrayList<ComptagenLigne> resultList = new ArrayList<ComptagenLigne>();
        for (List list : map.values()) {
            resultList.addAll(list);
        }
        return resultList;
    }

    private Journal getJournal(Mouvement mouvement) {
        Banque banque = mouvement.getBanque();
        String codeBanque = banque.getCodeBanque();
        Journal current = this.journalMap.get(codeBanque);
        if (current != null) {
            return current;
        }
        current = new InternalJournal(codeBanque, banque.getMotcle().getLabelString(this.bdfUser.getWorkingLang()));
        this.journalMap.put(codeBanque, current);
        return current;
    }

    private boolean containsDate(LocalDate date) {
        if (this.dateFilter == null) {
            return true;
        }
        return this.dateFilter.containsDate(date);
    }

    private static Motcle getMotcle(Thesaurus thesaurus, FichePointeur pointeur) {
        if (thesaurus == null) {
            return null;
        }
        Junctions junctions = pointeur.getJunctions((Subset)thesaurus);
        for (Junctions.Entry entry : junctions.getEntryList()) {
            Junction junction = entry.getJunction();
            if (!junction.containsMode("")) continue;
            return (Motcle)entry.getSubsetItem();
        }
        return null;
    }

    private String getShortTitle(FichePointeur lignePointeur) {
        Corpus corpus = lignePointeur.getCorpus();
        ShortTitleInfo info = this.getInfo(corpus);
        if (!info.hasField()) {
            return null;
        }
        FicheItem ficheItem = (FicheItem)lignePointeur.getValue(info.getFieldKey());
        if (ficheItem == null) {
            return null;
        }
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        return null;
    }

    private ShortTitleInfo getInfo(Corpus corpus) {
        SubsetKey subsetKey = corpus.getSubsetKey();
        ShortTitleInfo info = this.infoMap.get(subsetKey);
        if (info == null) {
            FieldKey shortTitleFieldKey = null;
            Attribute shortTitleAttribute = corpus.getCorpusMetadata().getAttributes().getAttribute(ScarabeSpace.SHORT_TITLE_KEY);
            if (shortTitleAttribute != null) {
                try {
                    FieldKey fieldKey = FieldKey.parse((String)shortTitleAttribute.getFirstValue());
                    CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField(fieldKey);
                    if (corpusField != null && fieldKey.isProp()) {
                        shortTitleFieldKey = fieldKey;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            info = new ShortTitleInfo(shortTitleFieldKey);
            this.infoMap.put(subsetKey, info);
        }
        return info;
    }

    private class CorpusExportEngine {
        private final FichePointeur lignePointeur;
        private final Corpus ligneCorpus;
        private final String alias;
        private final ComptagenExportLogHandler comptagenExportLogHandler;

        private CorpusExportEngine(String alias, ComptagenExportLogHandler comptagenExportLogHandler) {
            this.alias = alias;
            this.ligneCorpus = ExportEngine.this.coreAliasHolder.getCorpus(alias);
            this.lignePointeur = PointeurFactory.newFichePointeur((Corpus)this.ligneCorpus);
            this.comptagenExportLogHandler = comptagenExportLogHandler;
        }

        private void addLignes(Mouvement mouvement, Journal journal, Compte contrepartie, MoneyConversion moneyConversion, List<ComptagenLigne> resultList, String facture) {
            int numeropiece = mouvement.getNumeropiece();
            String pieceRef = numeropiece > 0 ? String.valueOf(numeropiece) : "";
            ComptagenLigneBuilder builder = ComptagenLigneBuilder.init(pieceRef, mouvement.getDate()).setModePaiement(mouvement.getModepaiement().getIdalpha()).setNumeroCheque(mouvement.getNumerocheque()).setJournal(journal).setContrepartie(contrepartie).setFacture(facture).setEcritureNum(mouvement.getId());
            if (this.alias.equals("depense")) {
                this.addLignes(builder, mouvement.getDepenseList(), mouvement, contrepartie, moneyConversion, resultList);
            } else if (this.alias.equals("apport")) {
                this.addLignes(builder, mouvement.getApportList(), mouvement, contrepartie, moneyConversion, resultList);
            } else if (this.alias.equals("avance")) {
                this.addLignes(builder, mouvement.getAvanceList(), mouvement, contrepartie, moneyConversion, resultList);
                this.addLignes(builder, mouvement.getSoldeAvanceList(), mouvement, contrepartie, moneyConversion, resultList);
            }
        }

        private void addLignes(ComptagenLigneBuilder builder, List<Ligne> ligneList, Mouvement mouvement, Compte contrepartie, MoneyConversion moneyConversion, List<ComptagenLigne> resultList) {
            for (Ligne ligne : ligneList) {
                Compte compte;
                Compte compteTiers;
                int id = ligne.getId();
                if (ligne.hasError()) {
                    this.comptagenExportLogHandler.excludeLigne(this.alias, id, ligne.getErrorMessageList());
                    continue;
                }
                this.lignePointeur.setCurrentSubsetItem((SubsetItem)ligne.getFicheMeta());
                Motcle plancomptableMotcle = ExportEngine.getMotcle(ExportEngine.this.plancomptableThesaurus, this.lignePointeur);
                if (plancomptableMotcle == null) {
                    Motcle comptetiersMotcle = ExportEngine.getMotcle(ExportEngine.this.comptetiersThesaurus, this.lignePointeur);
                    if (comptetiersMotcle == null) {
                        this.comptagenExportLogHandler.excludeLigne(this.alias, id, "PLANCOMPTABLE_NONE");
                        continue;
                    }
                    compteTiers = ComptagenUtils.toCompte(comptetiersMotcle, ExportEngine.this.lang);
                    String compteNumero = ScarabeSpace.getTiersRegroupement((SubsetItem)comptetiersMotcle);
                    if (compteNumero.isEmpty()) {
                        this.comptagenExportLogHandler.noCompteTiersAttribute(compteTiers.getNumero(), ScarabeSpace.TIERS_REGROUPEMENT);
                        continue;
                    }
                    compte = ComptagenUtils.toCompte(compteNumero, compteNumero);
                } else {
                    compte = ComptagenUtils.toCompte(plancomptableMotcle, ExportEngine.this.lang);
                    compteTiers = null;
                }
                builder.checkLigne(ligne).setShortTitle(ExportEngine.this.getShortTitle(this.lignePointeur)).setCompte(compte, compteTiers);
                long originalMoneyLong = ligne.getComputeMoneyLong();
                boolean debit = false;
                if (originalMoneyLong < 0L) {
                    debit = true;
                    originalMoneyLong = -originalMoneyLong;
                }
                if (!debit && contrepartie != null && ExportEngine.this.comptagenInfo.isContrepartie(compte.getNumero())) {
                    this.comptagenExportLogHandler.excludeLigne(this.alias, id, "DOUBLON_CONTREPARTIE");
                    continue;
                }
                if (moneyConversion != null) {
                    Decimal conversionRate;
                    long exportMoneyLong;
                    Long pivotMoneyLong = ligne.getPivotMoneyLong(ExportEngine.this.exportCurrency);
                    if (pivotMoneyLong != null) {
                        exportMoneyLong = pivotMoneyLong;
                        if (exportMoneyLong < 0L) {
                            exportMoneyLong = -exportMoneyLong;
                        }
                        conversionRate = MoneyUtils.getConversionRate((ExtendedCurrency)mouvement.getCurrency(), (long)originalMoneyLong, (ExtendedCurrency)ExportEngine.this.exportCurrency, (long)exportMoneyLong);
                    } else {
                        MoneyConversion checkedMoneyConversion = moneyConversion;
                        AvanceInfo avanceInfo = ligne.getAvanceInfo();
                        if (avanceInfo != null) {
                            checkedMoneyConversion = ExportEngine.this.coursManager.getMoneyConversion(avanceInfo.getAvanceDate(), ExportEngine.this.exportCurrency, mouvement.getCurrency());
                        }
                        conversionRate = checkedMoneyConversion.getConversionRate();
                        exportMoneyLong = checkedMoneyConversion.convertToPivot(originalMoneyLong);
                    }
                    builder.setMontant(debit, exportMoneyLong).setOriginalMontant(new Amount(originalMoneyLong, mouvement.getCurrency()), conversionRate);
                } else {
                    builder.setMontant(debit, originalMoneyLong).clearOriginalMontant();
                }
                resultList.add(builder.toComptagenLigne());
            }
        }
    }

    private static class InternalJournal
    implements Journal {
        private final String code;
        private final String libelle;

        private InternalJournal(String code, String libelle) {
            this.code = code;
            this.libelle = libelle;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getLibelle() {
            return this.libelle;
        }
    }

    private static class ShortTitleInfo {
        private final FieldKey fieldKey;

        private ShortTitleInfo(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        private boolean hasField() {
            return this.fieldKey != null;
        }

        private FieldKey getFieldKey() {
            return this.fieldKey;
        }
    }
}

