/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.Agregat;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatUnit;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.OperationBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetItem;

public class AgregatBuilder
extends OperationBuilder {
    private final AgregatDef agregatDef;
    private final int currencyLength;
    private final Map<SubsetItem, MutableMoneyByCurrency> unitMap = new HashMap<SubsetItem, MutableMoneyByCurrency>();

    public AgregatBuilder(AgregatDef agregatDef, int currencyLength) {
        super(agregatDef, currencyLength);
        this.agregatDef = agregatDef;
        this.currencyLength = currencyLength;
    }

    public void add(SubsetItem subsetItem, MoneyByCurrency moneyByCurrency) {
        MutableMoneyByCurrency current = this.unitMap.get(subsetItem);
        if (current == null) {
            current = new MutableMoneyByCurrency(this.currencyLength);
            this.unitMap.put(subsetItem, current);
        }
        current.add(moneyByCurrency);
    }

    public void add(SubsetItem subsetItem, int currencyIndex, long moneyLong) {
        MutableMoneyByCurrency current = this.unitMap.get(subsetItem);
        if (current == null) {
            current = new MutableMoneyByCurrency(this.currencyLength);
            this.unitMap.put(subsetItem, current);
        }
        current.add(currencyIndex, moneyLong);
    }

    @Override
    public Operation toOperation() {
        return this.toAgregat();
    }

    public Agregat toAgregat() {
        Operation operation = super.toOperation();
        AgregatUnit[] unitArray = new AgregatUnit[this.unitMap.size()];
        int p = 0;
        for (Map.Entry<SubsetItem, MutableMoneyByCurrency> entry : this.unitMap.entrySet()) {
            unitArray[p] = AnalytiqueUtils.toAgregatUnit(entry.getKey(), entry.getValue().toUnmodifiableMoneyByCurrency());
            ++p;
        }
        List<AgregatUnit> agregatUnitList = AnalytiqueUtils.wrap(unitArray);
        return new InternalAgregat(operation, agregatUnitList);
    }

    private static class InternalAgregat
    implements Agregat {
        private final Operation operation;
        private final List<AgregatUnit> agregatUnitList;

        public InternalAgregat(Operation operation, List<AgregatUnit> agregatUnitList) {
            this.operation = operation;
            this.agregatUnitList = agregatUnitList;
        }

        @Override
        public OperationDef getOperationDef() {
            return this.operation.getOperationDef();
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.operation.getMoneyByCurrency();
        }

        @Override
        public List<AgregatUnit> getUnitList() {
            return this.agregatUnitList;
        }
    }
}

