/* global ScarabeApi */

ScarabeApi.LigneDistribution = function () {
    this.depenseArray = new Array();
    this.avenirArray = new Array();
    this.apportArray = new Array();
};

ScarabeApi.LigneDistribution.DEFAULT_FILTER = function () {
    return true;
};

ScarabeApi.LigneDistribution.build = function (analytiqueDetail, ligneFilter, avenirFilter) {
    if (!ligneFilter) {
        ligneFilter = ScarabeApi.LigneDistribution.DEFAULT_FILTER;
    }
    if (!avenirFilter) {
        avenirFilter = ScarabeApi.LigneDistribution.DEFAULT_FILTER;
    }
    let distribution = new ScarabeApi.LigneDistribution();
    if (analytiqueDetail) {
        for(let ligne of analytiqueDetail.lignes) {
            if (ligneFilter(ligne)) {
                if (ligne.raccourci === "DE") {
                        distribution.depenseArray.push(ligne);
                } else if (ligne.raccourci === "AP") {
                        distribution.apportArray.push(ligne);
                }
            }
        }
        for(let avenir of analytiqueDetail.avenirs) {
            if (avenirFilter(avenir)) {
                distribution.avenirArray.push(avenir);
            }
        }
    }
    return distribution;
};

ScarabeApi.LigneDistribution.prototype.getArray = function (type) {
    switch(type) {
        case "depense":
            return this.depenseArray;
        case "apport":
            return this.apportArray;
        case "avenir":
            return this.avenirArray;
        default:
            throw "Unkown type: " + type;
    }
};

ScarabeApi.LigneDistribution.prototype.getLast = function (type) {
    var array = this.getArray(type);
    var length = array.length;
    if (length === 0) {
        return null;
    } else {
        return array[length - 1];
    }
};

ScarabeApi.LigneDistribution.prototype.has = function (type) {
    return (this.getArray(type).length > 0);
};

/**
 * 
 * @param {String} type
 * @param {String} currencyCode
 * @returns {Number|String} total ou "none"
 */
ScarabeApi.LigneDistribution.prototype.getTotal = function (type, currencyCode) {
    var array = this.getArray(type);
    var total = 0;
    var done = false;
    for(let item of array) {
        if (item.amount.hasOwnProperty(currencyCode)) {
            total += item.amount[currencyCode];
            done = true;
        }
    }
    if (!done) {
        return "none";
    }
    if ((_isOpposite(type)) && (total !== 0)) {
        total = - total;
    }
    return total;
        
        
    function _isOpposite(type) {
        switch(type) {
            case "depense":
            case "avenir":
                return true;
            default:
                return false;
        }
    }
    
};

ScarabeApi.LigneDistribution.prototype.addTotal = function (currentValue, type, currencyCode) {
    let total = this.getTotal(type, currencyCode);
    if (total !== "none") {
        if (currentValue === "none") {
            return total;
        } else {
            return currentValue + total;
        }
    } else {
        return currentValue;
    }
};
