/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.installation;

import fr.exemole.bdfext.scarabe.ScarabeBdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TreeManager;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.groups.GroupDefBuilder;
import fr.exemole.bdfserver.tools.groups.dom.GroupDefDOMReader;
import fr.exemole.bdfserver.tools.importation.engines.ThesaurusImportEngine;
import fr.exemole.bdfserver.tools.subsettree.TreeParser;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import fr.exemole.bdfserver.tools.ui.UiComponentsBuilder;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import fr.exemole.bdfserver.tools.ui.dom.UiComponentsDOMReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.alias.AliasDOMReader;
import net.fichotheque.tools.dom.CorpusMetadataDOMReader;
import net.fichotheque.tools.dom.ThesaurusMetadataDOMReader;
import net.fichotheque.tools.importation.dom.ThesaurusImportDOMReader;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.logging.SourceLogsBuilder;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public final class InstallationEngine {
    private final BdfParameters bdfParameters;
    private final BdfServer bdfServer;
    private final EditSession editSession;
    private final FichothequeEditor fichothequeEditor;
    private final MultiMessageHandler messageHandler;
    private final Set<Corpus> uiSet = new LinkedHashSet<Corpus>();
    private final Set<Subset> mouvementGroupSet = new LinkedHashSet<Subset>();
    private final Set<Subset> banqueGroupSet = new LinkedHashSet<Subset>();
    private final Set<Subset> nomenclatureGroupSet = new LinkedHashSet<Subset>();
    private final StringBuilder corpusTreeBuilder;
    private final StringBuilder thesaurusTreeBuilder;

    private InstallationEngine(EditSession editSession, BdfParameters bdfParameters) {
        this.bdfServer = bdfParameters.getBdfServer();
        this.editSession = editSession;
        this.bdfParameters = bdfParameters;
        this.fichothequeEditor = editSession.getFichothequeEditor();
        this.messageHandler = new SourceLogsBuilder();
        TreeManager treeManager = this.bdfServer.getTreeManager();
        this.corpusTreeBuilder = new StringBuilder(TreeUtils.toString((SubsetTree)treeManager.getSubsetTree((short)1)));
        this.thesaurusTreeBuilder = new StringBuilder(TreeUtils.toString((SubsetTree)treeManager.getSubsetTree((short)2)));
    }

    private void readCore() {
        AliasDOMReader alias = this.getAlias("core");
        ThesaurusEditor banqueEditor = this.loadThesaurus(alias.getThesaurusKey("banque"), this.banqueGroupSet);
        this.loadThesaurus(alias.getThesaurusKey("modepaiement"), this.mouvementGroupSet);
        this.loadThesaurus(alias.getThesaurusKey("rapprochement"), this.mouvementGroupSet);
        this.loadCorpus(alias.getCorpusKey("mouvement"), null, this.mouvementGroupSet);
        this.loadCorpus(alias.getCorpusKey("depense"), null, this.mouvementGroupSet);
        this.loadCorpus(alias.getCorpusKey("apport"), null, this.mouvementGroupSet);
        this.loadCorpus(alias.getCorpusKey("avance"), null, this.mouvementGroupSet);
        this.loadCorpus(alias.getCorpusKey("banque"), (Subset)banqueEditor.getThesaurus(), this.banqueGroupSet);
    }

    private void readComptagen() {
        AliasDOMReader alias = this.getAlias("comptagen");
        this.loadThesaurus(alias.getThesaurusKey("plancomptable"), this.nomenclatureGroupSet);
    }

    private void readUi() {
        BdfServerEditor bdfServerEditor = this.editSession.getBdfServerEditor();
        HtmlCleaner htmlCleaner = this.bdfServer.getUiManager().getHtmlCleaner();
        for (Corpus corpus : this.uiSet) {
            String uiPath = "tools/defaultfiles/ui/" + corpus.getSubsetName() + ".xml";
            if (ScarabeBdfExtensionInitializer.class.getResource(uiPath) == null) continue;
            this.messageHandler.setCurrentSource(uiPath);
            try {
                InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream(uiPath);
                try {
                    Document document = DOMUtils.readDocument((InputStream)is);
                    UiComponentsBuilder uiComponentsBuilder = new UiComponentsBuilder();
                    UiComponentsDOMReader reader = new UiComponentsDOMReader(uiComponentsBuilder, htmlCleaner, (MessageHandler)this.messageHandler);
                    reader.readUiComponents(document.getDocumentElement());
                    UiUtils.updateUi((BdfServerEditor)bdfServerEditor, (Corpus)corpus, (UiComponents)uiComponentsBuilder.toUiComponents());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
    }

    private void readGroups() {
        BdfServerEditor bdfServerEditor = this.editSession.getBdfServerEditor();
        this.readGroup(bdfServerEditor, "mouvement", this.mouvementGroupSet);
        this.readGroup(bdfServerEditor, "banque", this.banqueGroupSet);
        this.readGroup(bdfServerEditor, "nomenclature", this.nomenclatureGroupSet);
        bdfServerEditor.setSubsetTree((short)1, TreeParser.parse((BdfServer)this.bdfServer, (String)this.corpusTreeBuilder.toString(), (short)1));
        bdfServerEditor.setSubsetTree((short)2, TreeParser.parse((BdfServer)this.bdfServer, (String)this.thesaurusTreeBuilder.toString(), (short)2));
    }

    private boolean readGroup(BdfServerEditor bdfServerEditor, String name, Set<Subset> groupSet) {
        GroupDef importGroupDef;
        if (groupSet.isEmpty()) {
            return false;
        }
        if (this.bdfServer.getGroupManager().getGroupDef(name) != null) {
            return false;
        }
        String groupPath = "tools/defaultfiles/groups/" + name + ".xml";
        try (InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream(groupPath);){
            Document document = DOMUtils.readDocument((InputStream)is);
            GroupDefBuilder groupDefBuilder = new GroupDefBuilder(name);
            GroupDefDOMReader.init((GroupDefBuilder)groupDefBuilder, (MessageHandler)this.messageHandler).read(document.getDocumentElement());
            importGroupDef = groupDefBuilder.toGroupDef();
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        GroupDef bdfGroupDef = bdfServerEditor.createGroupDef(name);
        for (Label label : importGroupDef.getTitleLabels()) {
            bdfServerEditor.putLabel((Object)bdfGroupDef, label);
        }
        this.addSubsets(name, (short)1, groupSet, this.corpusTreeBuilder);
        this.addSubsets(name, (short)2, groupSet, this.thesaurusTreeBuilder);
        return true;
    }

    private void addSubsets(String name, short category, Set<Subset> groupSet, StringBuilder buf) {
        ArrayList<Subset> filterList = new ArrayList<Subset>();
        for (Subset subset : groupSet) {
            SubsetKey subsetKey = subset.getSubsetKey();
            if (subsetKey.getCategory() != category) continue;
            filterList.add(subset);
        }
        if (filterList.isEmpty()) {
            return;
        }
        buf.append("\n\n+ ");
        buf.append(name);
        buf.append("\n");
        for (Subset subset : filterList) {
            buf.append("  ");
            buf.append(subset.getSubsetKeyString());
            buf.append("\n");
        }
        buf.append("\n- ");
        buf.append(name);
        buf.append("\n");
    }

    private AliasDOMReader getAlias(String group) {
        AliasDOMReader aliasDOMReader;
        block8: {
            InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream("tools/defaultfiles/scarabe-alias-" + group + ".xml");
            try {
                Document document = DOMUtils.readDocument((InputStream)is);
                AliasDOMReader reader = new AliasDOMReader(null);
                reader.readAlias(document.getDocumentElement());
                aliasDOMReader = reader;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return aliasDOMReader;
    }

    private ThesaurusEditor loadThesaurus(SubsetKey thesaurusKey, Set<Subset> groupSet) {
        ThesaurusEditor thesaurusEditor = this.fichothequeEditor.getThesaurusEditor(thesaurusKey);
        if (thesaurusEditor == null) {
            try {
                thesaurusEditor = this.fichothequeEditor.createThesaurus(thesaurusKey, "idalpha");
                groupSet.add((Subset)thesaurusEditor.getThesaurus());
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("Test done before");
            }
        }
        String metadataPath = "tools/defaultfiles/thesaurus/" + thesaurusKey.getSubsetName() + ".xml";
        this.messageHandler.setCurrentSource(metadataPath);
        try (InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream(metadataPath);){
            Document document = DOMUtils.readDocument((InputStream)is);
            ThesaurusMetadataDOMReader domReader = new ThesaurusMetadataDOMReader(thesaurusEditor.getThesaurusMetadataEditor(), (MessageHandler)this.messageHandler);
            domReader.fillMetadata(document.getDocumentElement());
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        String importPath = "tools/defaultfiles/thesaurus/" + thesaurusKey.getSubsetName() + "-import.xml";
        if (ScarabeBdfExtensionInitializer.class.getResource(importPath) != null) {
            this.messageHandler.setCurrentSource(importPath);
            ThesaurusImportBuilder thesaurusImportBuilder = ThesaurusImportBuilder.init((Thesaurus)thesaurusEditor.getThesaurus(), (String)"edit");
            try (InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream(importPath);){
                Document document = DOMUtils.readDocument((InputStream)is);
                ThesaurusImportDOMReader.init((ThesaurusImportBuilder)thesaurusImportBuilder).read(document.getDocumentElement());
                ThesaurusImportEngine.runThesaurusImport((EditSession)this.editSession, (BdfParameters)this.bdfParameters, (ThesaurusImport)thesaurusImportBuilder.toThesaurusImport());
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        return thesaurusEditor;
    }

    private CorpusEditor loadCorpus(SubsetKey corpusKey, Subset masterSubset, Set<Subset> groupSet) {
        CorpusEditor corpusEditor = this.fichothequeEditor.getCorpusEditor(corpusKey);
        if (corpusEditor == null) {
            try {
                corpusEditor = this.fichothequeEditor.createCorpus(corpusKey, masterSubset);
                this.uiSet.add(corpusEditor.getCorpus());
                groupSet.add((Subset)corpusEditor.getCorpus());
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("Test done before");
            }
        }
        String path = "tools/defaultfiles/corpus/" + corpusKey.getSubsetName() + ".xml";
        this.messageHandler.setCurrentSource(path);
        try (InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream(path);){
            Document document = DOMUtils.readDocument((InputStream)is);
            CorpusMetadataDOMReader domReader = new CorpusMetadataDOMReader(corpusEditor.getCorpusMetadataEditor(), (MessageHandler)this.messageHandler);
            domReader.fillMetadata(document.getDocumentElement());
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return corpusEditor;
    }

    public static void run(EditSession editSession, BdfParameters bdfParameters) {
        InstallationEngine engine = new InstallationEngine(editSession, bdfParameters);
        engine.readCore();
        engine.readComptagen();
        engine.readUi();
        engine.readGroups();
    }
}

