/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation.banque;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.BanqueDetail;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.exportation.CategoryColumnDef;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import fr.exemole.bdfserver.tools.BH;
import net.fichotheque.SubsetItem;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.date.FuzzyDateFormatter;
import net.mapeadores.util.date.RangeDateFilter;
import net.mapeadores.util.money.ExtendedCurrency;

public class MouvementTableEngine
extends TableEngine {
    private final BanqueDetail banqueDetail;
    private final ExtendedCurrency currency;
    private final OdTableDef odTableDef;
    private final String title;
    private long soldeprogressif = 0L;
    private long debit = 0L;
    private long credit = 0L;

    public MouvementTableEngine(BanqueDetail banqueDetail, ScarabeLocalisation scarabeLocalisation) {
        super(scarabeLocalisation);
        this.banqueDetail = banqueDetail;
        this.soldeprogressif = banqueDetail.getCreditReport() - banqueDetail.getDebitReport();
        Banque banque = banqueDetail.getBanque();
        this.currency = banque.getCurrency();
        this.odTableDef = OdTableDefBuilder.init((String)"").addDate(this.getDatePattern()).add((OdColumnDef)CategoryColumnDef.buildStandard("PIECE")).add((OdColumnDef)CategoryColumnDef.buildStandard("ID")).addStandard().addStandard().addStandard().addCurrency(this.currency).addCurrency(this.currency).add((OdColumnDef)CategoryColumnDef.buildCurrency(this.currency, "SOLDE")).toOdTableDef();
        this.title = this.initTitle(scarabeLocalisation);
    }

    private String initTitle(ScarabeLocalisation scarabeLocalisation) {
        Banque banque = this.banqueDetail.getBanque();
        RangeDateFilter rangeDateIntegerFilter = this.banqueDetail.getRangeDateIntegerFilter();
        StringBuilder buf = new StringBuilder();
        buf.append(banque.getTitle(scarabeLocalisation.getWorkingLang()));
        buf.append(" (");
        buf.append(scarabeLocalisation.getMessageLocalisation().toString("_ label.scarabe.detailtype_mouvement"));
        buf.append(")");
        if (rangeDateIntegerFilter != null) {
            FuzzyDateFormatter formatter = scarabeLocalisation.getLongFuzzyDateFormatter();
            buf.append(" / ");
            FuzzyDate min = rangeDateIntegerFilter.getMinDate();
            buf.append(formatter.format(min));
            FuzzyDate max = rangeDateIntegerFilter.getMaxDate();
            if (!max.equals((Object)min)) {
                buf.append(" - ");
                buf.append(formatter.format(max));
            }
        }
        return buf.toString();
    }

    @Override
    public OdTableDef getOdTableDef() {
        return this.odTableDef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeHead(ScarabeTableWriter tableWriter) {
        tableWriter.startRow((short)101);
        tableWriter.addStringCell(this.title, 9);
        tableWriter.endRow();
        tableWriter.startRow((short)103);
        tableWriter.addMessageCell("_ label.scarabe.date");
        tableWriter.addMessageCell("_ label.scarabe.numeropiece");
        tableWriter.addMessageCell("_ label.scarabe.fiche_mouvement");
        tableWriter.addMessageCell("_ label.scarabe.beneficiaire");
        tableWriter.addMessageCell("_ label.scarabe.libelle");
        tableWriter.addMessageCell("_ label.scarabe.rapprochement");
        tableWriter.addMessageCell("_ label.scarabe.debit");
        tableWriter.addMessageCell("_ label.scarabe.credit");
        tableWriter.addMessageCell("_ label.scarabe.solde_progressive");
        tableWriter.endRow();
    }

    @Override
    public void writeBody(ScarabeTableWriter tableWriter) {
        this.printSoldeRow(tableWriter, "_ label.scarabe.solde_old");
        for (Mouvement mouvement : this.banqueDetail.getMouvementList()) {
            this.printRows(tableWriter, mouvement);
        }
        this.printTotalRow(tableWriter);
        this.printSoldeRow(tableWriter, "_ label.scarabe.solde_new");
    }

    private void printRows(ScarabeTableWriter tableWriter, Mouvement mouvement) {
        tableWriter.startRow();
        tableWriter.addDateCell(mouvement.getDate());
        tableWriter.addIntegerCell(mouvement.getNumeropiece());
        String href = BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)mouvement.getFicheMeta()).toString();
        tableWriter.addHrefCell(href, mouvement.getId());
        tableWriter.addStringCell(mouvement.getBeneficiaireString());
        tableWriter.addStringCell(mouvement.getLibelle());
        this.printMotcleCell(tableWriter, mouvement.getRapprochement());
        long montant = mouvement.getMontantMoneyLong();
        if (mouvement.isDebit()) {
            tableWriter.addMoneyCell(montant, this.currency);
            tableWriter.addNullCell(1);
            this.debit += montant;
            this.soldeprogressif -= montant;
            tableWriter.addMoneyCell(this.soldeprogressif, this.currency);
        } else {
            tableWriter.addNullCell(1);
            tableWriter.addMoneyCell(montant, this.currency);
            this.credit += montant;
            this.soldeprogressif += montant;
            tableWriter.addMoneyCell(this.soldeprogressif, this.currency);
        }
        tableWriter.endRow();
    }

    private void printMotcleCell(ScarabeTableWriter tableWriter, Motcle motcle) {
        if (motcle == null) {
            tableWriter.addNullCell(1);
        } else {
            tableWriter.addStringCell(motcle.getIdalpha());
        }
    }

    private void printSoldeRow(ScarabeTableWriter tableWriter, String messageKey) {
        tableWriter.startRow((short)102);
        tableWriter.addNullCell(4);
        tableWriter.addMessageCell(messageKey);
        tableWriter.addNullCell(3);
        tableWriter.addMoneyCell(this.soldeprogressif, this.currency);
        tableWriter.endRow();
    }

    private void printTotalRow(ScarabeTableWriter tableWriter) {
        tableWriter.startRow((short)104);
        tableWriter.addNullCell(4);
        tableWriter.addMessageCell("_ label.scarabe.totaux");
        tableWriter.addNullCell(1);
        tableWriter.addMoneyCell(this.debit, this.currency);
        tableWriter.addMoneyCell(this.credit, this.currency);
        tableWriter.addNullCell(1);
        tableWriter.endRow();
    }
}

