/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation;

import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.mapeadores.opendocument.io.OdUtils;
import net.mapeadores.opendocument.io.SheetNameChecker;
import net.mapeadores.opendocument.io.SheetWriter;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.opendocument.io.odtable.SheetHandler;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.opendocument.io.odtable.StyleManagerBuilder;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.TempStorageAppendable;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public final class OdsTableOutput {
    public static final String TITRE_STYLE = "Scarabe_20_Titre";
    public static final String INTITULE_STYLE = "Scarabe_20_Intitule";
    public static final String TOTAUX_STYLE = "Scarabe_20_Totaux";
    public static final String SOLDE_STYLE = "Scarabe_20_Solde";
    public static final String TITREINTERMEDIAIRE_STYLE = "Scarabe_20_Titre_20_Intermediaire";
    public static final String DATESANTERIEURES_STYLE = "Scarabe_20_Dates_20_Anterieures";
    public static final String AVANCESOLDEE_STYLE = "Scarabe_20_Avance_20_Soldee";
    public static final String AVENIR_TOTAUX_STYLE = "Scarabe_20_Avenir_20_Totaux";
    public static final String AVENIR_TITREINTERMEDIAIRE_STYLE = "Scarabe_20_Avenir_20_Titre_20_Intermediaire";
    public static final String AVENIR_STYLE = "Scarabe_20_Avenir";
    public static final String AVENIR_DATESANTERIEURES_STYLE = "Scarabe_20_Avenir_20_Dates_20_Anterieures";
    public static final String SOLDE_DETAIL_STYLE = "Scarabe_20_Solde_20_Detail";
    public static final String AGREGAT_DETAIL_STYLE = "Scarabe_20_Agregat_20_Detail";

    private OdsTableOutput() {
    }

    public static void write(OutputStream outputStream, TableEngine tableEngine, SheetWriter supplementarySheetWriter) throws IOException {
        SheetHandler supplementarySheetHandler;
        SheetNameChecker sheetNameChecker = new SheetNameChecker();
        StyleManagerBuilder styleManagerBuilder = new StyleManagerBuilder();
        String name = sheetNameChecker.checkName(tableEngine.getTitle());
        styleManagerBuilder.putTableDef(name, tableEngine.getOdTableDef());
        if (supplementarySheetWriter != null) {
            supplementarySheetHandler = new SheetHandler(supplementarySheetWriter);
            supplementarySheetHandler.addSupplementary(styleManagerBuilder, sheetNameChecker);
        } else {
            supplementarySheetHandler = null;
        }
        StyleManager styleManager = styleManagerBuilder.toStyleManager();
        TempStorageAppendable bodyBuffer = new TempStorageAppendable();
        OdsTableWriter odsTableWriter = new OdsTableWriter(name, (XMLWriter)XMLUtils.toXMLWriter((Appendable)bodyBuffer, (int)3), tableEngine.getScarabeLocalisation().getMessageLocalisation(), styleManager);
        odsTableWriter.tableStart(name);
        tableEngine.writeHead(odsTableWriter);
        tableEngine.writeBody(odsTableWriter);
        odsTableWriter.tableEnd();
        if (supplementarySheetHandler != null) {
            supplementarySheetHandler.writeSupplementary((OdsXMLPart)odsTableWriter);
        }
        OdUtils.writeSpreadSheetDocumentContent((OutputStream)outputStream, (Consumer)bodyBuffer, (StyleManager)styleManager);
    }

    public static String getMatchingStyleName(short type) {
        switch (type) {
            case 101: {
                return TITRE_STYLE;
            }
            case 102: {
                return SOLDE_STYLE;
            }
            case 103: {
                return INTITULE_STYLE;
            }
            case 104: 
            case 115: {
                return TOTAUX_STYLE;
            }
            case 105: {
                return TITREINTERMEDIAIRE_STYLE;
            }
            case 106: {
                return AVANCESOLDEE_STYLE;
            }
            case 108: {
                return AVENIR_TITREINTERMEDIAIRE_STYLE;
            }
            case 109: {
                return AVENIR_TOTAUX_STYLE;
            }
            case 110: {
                return AVENIR_STYLE;
            }
            case 111: {
                return DATESANTERIEURES_STYLE;
            }
            case 112: {
                return AVENIR_DATESANTERIEURES_STYLE;
            }
            case 113: {
                return AGREGAT_DETAIL_STYLE;
            }
            case 114: {
                return SOLDE_DETAIL_STYLE;
            }
        }
        return null;
    }

    private static boolean insertEmptyRowBefore(short type) {
        switch (type) {
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 113: 
            case 114: {
                return true;
            }
        }
        return false;
    }

    private static boolean insertEmptyRowAfter(short type) {
        switch (type) {
            case 102: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    private static class OdsTableWriter
    extends OdsXMLPart
    implements ScarabeTableWriter {
        private final String tableName;
        private final MessageLocalisation messageLocalisation;
        private int rowNumber;
        private int columnNumber;
        private short currentRowType = (short)100;

        private OdsTableWriter(String tableName, XMLWriter xmlWriter, MessageLocalisation messageLocalisation, StyleManager styleManager) {
            super(xmlWriter, styleManager);
            this.tableName = tableName;
            this.messageLocalisation = messageLocalisation;
        }

        public int startRow() {
            return this.startRow((short)100);
        }

        @Override
        public int startRow(short rowType) {
            ++this.rowNumber;
            this.currentRowType = rowType;
            try {
                if (OdsTableOutput.insertEmptyRowBefore(rowType)) {
                    this.rowStart().rowEnd();
                    ++this.rowNumber;
                }
                this.rowStart();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            this.columnNumber = 0;
            return this.rowNumber;
        }

        @Override
        public void addNullCell(int cellCount) {
            for (int i = 0; i < cellCount; ++i) {
                try {
                    this.emptyCell();
                    continue;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            this.columnNumber += cellCount;
        }

        @Override
        public int addMessageCell(String messageKey) {
            this.addMessageCell(messageKey, 1, false);
            return this.columnNumber;
        }

        @Override
        public void addMessageCell(String messageKey, int colspan, boolean withColon) {
            String rscLoc = this.messageLocalisation.toString(messageKey);
            if (withColon) {
                rscLoc = rscLoc + " :";
            }
            this.addStringCell(rscLoc, colspan);
        }

        public int addStringCell(String text) {
            this.addStringCell(text, 1, false);
            return this.columnNumber;
        }

        @Override
        public void addStringCell(String text, int colspan) {
            this.addStringCell(text, colspan, false);
        }

        @Override
        public void addStringCell(String text, int colspan, boolean withColon) {
            ++this.columnNumber;
            String cellStyleName = this.getStandardStyleName();
            if (withColon) {
                text = text + " :";
            }
            try {
                this.stringCell(text, cellStyleName, colspan);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            this.columnNumber += colspan - 1;
        }

        @Override
        public int addHrefCell(String href, String text) {
            ++this.columnNumber;
            String cellStyleName = this.getStandardStyleName();
            try {
                this.stringCell(text, cellStyleName, 1);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addHrefCell(String href, int integer) {
            ++this.columnNumber;
            String cellStyleName = this.getStandardStyleName();
            try {
                this.numberCell(String.valueOf(integer), cellStyleName, 1);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        @Override
        public int addMoneyCell(long moneyLong, ExtendedCurrency currency) {
            return this.addMoneyCell(new Amount(moneyLong, currency));
        }

        public int addMoneyCell(Amount amount) {
            ++this.columnNumber;
            String parentStyleName = this.getParentStyleName();
            String cellStyleName = this.getStyleManager().getCurrencyCellStyleName(this.tableName, this.columnNumber, amount.getCurrency(), parentStyleName);
            try {
                this.currencyCell(amount, cellStyleName);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        public int addDateCell(FuzzyDate date) {
            ++this.columnNumber;
            String parentStyleName = this.getParentStyleName();
            String cellStyleName = this.getStyleManager().getDateCellStyleName(this.tableName, this.columnNumber, null, parentStyleName);
            try {
                this.dateCell(date, cellStyleName);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        public int addDecimalCell(Decimal decimal) {
            ++this.columnNumber;
            try {
                if (decimal == null) {
                    this.emptyCell();
                } else {
                    String cellStyleName = this.getStandardStyleName();
                    this.numberCell(decimal.toString(), cellStyleName);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        public int addPercentageCell(Decimal decimal) {
            ++this.columnNumber;
            try {
                if (decimal == null) {
                    this.emptyCell();
                } else {
                    String cellStyleName = this.getStandardStyleName();
                    this.percentageCell(decimal.toString(), cellStyleName);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        public int addIntegerCell(Long lg) {
            ++this.columnNumber;
            try {
                if (lg == null) {
                    this.emptyCell();
                } else {
                    String cellStyleName = this.getStandardStyleName();
                    this.numberCell(String.valueOf(lg), cellStyleName);
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return this.columnNumber;
        }

        public int endRow() {
            int oldRowNumber = this.rowNumber++;
            try {
                this.rowEnd();
                if (OdsTableOutput.insertEmptyRowAfter(this.currentRowType)) {
                    this.rowStart().rowEnd();
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            return oldRowNumber;
        }

        private String getStandardStyleName() {
            String parentStyleName = this.getParentStyleName();
            return this.getStyleManager().getStandardCellStyleName(this.tableName, this.columnNumber, parentStyleName);
        }

        private String getParentStyleName() {
            String parentStyleName = null;
            if (parentStyleName == null) {
                parentStyleName = OdsTableOutput.getMatchingStyleName(this.currentRowType);
            }
            return parentStyleName;
        }
    }
}

