/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.configuration.TableDefConfig;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeColDef;
import fr.exemole.bdfext.scarabe.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.exportation.table.CellConversionInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableDefItem;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.tools.exportation.table.SubsetTableBuilder;
import net.fichotheque.tools.exportation.table.TableExportBuilder;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.instruction.InstructionUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Labels;

public class Columns {
    private static final Cell[] EMPTY_ARRAY = new Cell[0];
    private final List<ColDef> colDefList;
    private final CellConverter cellConverter;
    private final Column[] columnArray;
    private final int columnLength;
    private final int dateIndex;
    private final int numeropieceIndex;
    private final int idIndex;
    private final int beneficiaireIndex;
    private final int libelleIndex;
    private final int mouvementidIndex;
    private final int modepaiementIndex;
    private final int numerochequeIndex;
    private final int rapprochementIndex;
    private final int debitIndex;
    private final int creditIndex;
    private final int montantimputeIndex;
    private final Cell[] currentCellArray;

    private Columns(Builder builder, CellConverter cellConverter) {
        this.columnArray = builder.toColumnArray();
        this.colDefList = builder.getFinalColDefList();
        this.columnLength = this.columnArray.length;
        this.dateIndex = builder.getColumnIndex("scarabe_date");
        this.numeropieceIndex = builder.getColumnIndex("scarabe_numeropiece");
        this.idIndex = builder.getColumnIndex("scarabe_id");
        this.beneficiaireIndex = builder.getColumnIndex("scarabe_beneficiaire");
        this.libelleIndex = builder.getColumnIndex("scarabe_libelle");
        this.mouvementidIndex = builder.getColumnIndex("scarabe_mouvementid");
        this.modepaiementIndex = builder.getColumnIndex("scarabe_modepaiement");
        this.numerochequeIndex = builder.getColumnIndex("scarabe_numerocheque");
        this.rapprochementIndex = builder.getColumnIndex("scarabe_rapprochement");
        this.debitIndex = builder.getColumnIndex("scarabe_debit");
        this.creditIndex = builder.getColumnIndex("scarabe_credit");
        this.montantimputeIndex = builder.getColumnIndex("scarabe_montantimpute");
        this.currentCellArray = new Cell[this.columnLength];
        this.cellConverter = cellConverter;
    }

    public int getCount() {
        return this.columnLength;
    }

    public boolean isDate(int index) {
        return index == this.dateIndex;
    }

    public boolean isNumeropiece(int index) {
        return index == this.numeropieceIndex;
    }

    public boolean isId(int index) {
        return index == this.idIndex;
    }

    public boolean isBeneficiaire(int index) {
        return index == this.beneficiaireIndex;
    }

    public boolean isLibelle(int index) {
        return index == this.libelleIndex;
    }

    public boolean isMouvementid(int index) {
        return index == this.mouvementidIndex;
    }

    public boolean isModepaiement(int index) {
        return index == this.modepaiementIndex;
    }

    public boolean isNumerocheque(int index) {
        return index == this.numerochequeIndex;
    }

    public boolean isRapprochement(int index) {
        return index == this.rapprochementIndex;
    }

    public boolean isDebit(int index) {
        return index == this.debitIndex;
    }

    public boolean isCredit(int index) {
        return index == this.creditIndex;
    }

    public boolean isMontantimpute(int index) {
        return index == this.montantimputeIndex;
    }

    public String getFormatCast(int index) {
        return this.columnArray[index].formatCast;
    }

    public List<ColDef> getColDefList() {
        return this.colDefList;
    }

    public void setCurrentFicheMeta(FicheMeta ficheMeta) {
        Cell[] cellArray = this.cellConverter.toCellArray((SubsetItem)ficheMeta);
        if (cellArray != null) {
            for (int i = 0; i < this.columnLength; ++i) {
                Cell cell = null;
                int matchingIndex = this.columnArray[i].matchingCustomIndex;
                if (matchingIndex != -1) {
                    cell = cellArray[matchingIndex];
                }
                this.currentCellArray[i] = cell;
            }
        } else {
            for (int i = 0; i < this.columnLength; ++i) {
                this.currentCellArray[i] = null;
            }
        }
    }

    public Cell getCurrentCell(int index) {
        return this.currentCellArray[index];
    }

    public CellConverter getCellConverter() {
        return this.cellConverter;
    }

    public Cell[] toCellArray(FicheMeta ficheMeta) {
        Cell[] cellArray = this.cellConverter.toCellArray((SubsetItem)ficheMeta);
        if (cellArray != null) {
            return cellArray;
        }
        return EMPTY_ARRAY;
    }

    public static Columns build(BdfParameters bdfParameters, ScarabeContext scarabeContext, Lang workingLang, String tableDefName, List<ColDef> scarabeColDefList) {
        TableDefConfig ligneTableDefConfig = ConfigurationUtils.getTableDefConfig(scarabeContext, tableDefName);
        TableDef tableDef = null;
        if (ligneTableDefConfig != null) {
            tableDef = ligneTableDefConfig.getTableDef();
        }
        return Columns.build(bdfParameters, scarabeContext, workingLang, tableDef, scarabeColDefList);
    }

    public static Columns build(BdfParameters bdfParameters, ScarabeContext scarabeContext, Lang workingLang, TableDef customTableDef, List<ColDef> scarabeColDefList) {
        CellConverter cellConverter;
        Builder builder = new Builder(scarabeColDefList);
        builder.build(customTableDef);
        if (builder.hasCustom()) {
            BdfServer bdfServer = bdfParameters.getBdfServer();
            TableDef checkedTableDef = builder.getCheckedCustomTableDef();
            TableExportContext tableExportContext = bdfServer.getTableExportContext();
            AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
            TableExport tableExport = TableExportBuilder.init().addSubsetTable(Columns.initSubsetTable(coreAliasHolder.getCorpus("depense"), checkedTableDef, tableExportContext)).addSubsetTable(Columns.initSubsetTable(coreAliasHolder.getCorpus("apport"), checkedTableDef, tableExportContext)).addSubsetTable(Columns.initSubsetTable(coreAliasHolder.getCorpus("avance"), checkedTableDef, tableExportContext)).toTableExport();
            cellConverter = CellConversionInit.tableExport((BdfServer)bdfServer, (ExtractionContext)bdfParameters.getDefaultExtractionContext(), (TableExport)tableExport).getCellConverter();
        } else {
            cellConverter = TableExportUtils.EMPTY_CELLCONVERTER;
        }
        Columns columns = new Columns(builder, cellConverter);
        return columns;
    }

    private static SubsetTable initSubsetTable(Corpus corpus, TableDef tableDef, TableExportContext tableExportContext) {
        return SubsetTableBuilder.init((Subset)corpus).populate(tableDef, tableExportContext, true, ";").toSubsetTable();
    }

    private static class Builder {
        private final Map<String, Column> columnMap = new HashMap<String, Column>();
        private final List<Column> columnList = new ArrayList<Column>();
        private final List<TableDefItem> customList = new ArrayList<TableDefItem>();
        private final Map<String, ColDef> standardNotDoneMap = new LinkedHashMap<String, ColDef>();
        private int currentColumnIndex = -1;

        private Builder(List<ColDef> scarabeColDefList) {
            for (ColDef scarabeColDef : scarabeColDefList) {
                this.standardNotDoneMap.put(scarabeColDef.getColName(), scarabeColDef);
            }
        }

        private boolean containsStandard(TableDef tableDef) {
            if (tableDef == null) {
                return false;
            }
            for (TableDefItem defItem : tableDef.getDefItemList()) {
                if (!(defItem instanceof TableInclusionDef) || !this.standardNotDoneMap.containsKey(((TableInclusionDef)defItem).getNameSpace())) continue;
                return true;
            }
            return false;
        }

        private void build(TableDef customTableDef) {
            boolean withStandard = this.containsStandard(customTableDef);
            if (!withStandard) {
                for (ColDef coldDef : this.standardNotDoneMap.values()) {
                    this.addStandard(coldDef);
                }
            }
            if (customTableDef != null) {
                for (TableDefItem defItem : customTableDef.getDefItemList()) {
                    if (defItem instanceof FormatColDef) {
                        this.addCustom((FormatColDef)defItem);
                        continue;
                    }
                    if (!(defItem instanceof TableInclusionDef)) continue;
                    this.addStandard((TableInclusionDef)defItem);
                }
            }
            if (withStandard) {
                for (ColDef coldDef : this.standardNotDoneMap.values()) {
                    this.addStandard(coldDef);
                }
            }
        }

        private void addCustom(FormatColDef formatColDef) {
            String name = formatColDef.getColName();
            if (this.standardNotDoneMap.containsKey(name)) {
                return;
            }
            if (this.columnMap.containsKey(name)) {
                return;
            }
            ++this.currentColumnIndex;
            int matchingIndex = this.customList.size();
            Column column = new Column((ColDef)formatColDef, this.currentColumnIndex, matchingIndex);
            this.columnMap.put(name, column);
            this.columnList.add(column);
            this.customList.add((TableDefItem)formatColDef);
        }

        private void addStandard(TableInclusionDef tableInclusionDef) {
            Labels labels;
            String name = tableInclusionDef.getNameSpace();
            if (!this.standardNotDoneMap.containsKey(name)) {
                return;
            }
            ColDef scarabeColDef = this.standardNotDoneMap.get(name);
            this.standardNotDoneMap.remove(name);
            List configLineList = tableInclusionDef.getConfigLineList();
            if (!configLineList.isEmpty()) {
                if (this.columnMap.containsKey(name)) {
                    return;
                }
                Instruction instruction = InstructionParser.parse((String)((String)configLineList.get(0)), (InstructionErrorHandler)InstructionUtils.DEFAULT_ERROR_HANDLER);
                if (instruction != null) {
                    for (Argument argument : instruction) {
                        if (!argument.getKey().equals("hidden")) continue;
                        this.columnMap.put(name, null);
                        return;
                    }
                }
            }
            if ((labels = tableInclusionDef.getLabels()) == null) {
                this.addStandard(scarabeColDef);
            } else {
                this.addStandard(ScarabeColDef.derive((ScarabeColDef)scarabeColDef, labels));
            }
        }

        private void addStandard(ColDef colDef) {
            String name = colDef.getColName();
            if (this.columnMap.containsKey(name)) {
                return;
            }
            ++this.currentColumnIndex;
            Column column = new Column(colDef, this.currentColumnIndex, -1);
            this.columnMap.put(name, column);
            this.columnList.add(column);
        }

        private Column[] toColumnArray() {
            return this.columnList.toArray(new Column[this.columnList.size()]);
        }

        private List<ColDef> getFinalColDefList() {
            int size = this.columnList.size();
            ColDef[] array = new ColDef[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.columnList.get(i).colDef;
            }
            return TableDefUtils.wrap((ColDef[])array);
        }

        private int getColumnIndex(String name) {
            Column column = this.columnMap.get(name);
            if (column == null) {
                return -1;
            }
            return column.colIndex;
        }

        private boolean hasCustom() {
            return !this.customList.isEmpty();
        }

        private TableDef getCheckedCustomTableDef() {
            return TableDefUtils.toTableDef(this.customList);
        }
    }

    private static class Column {
        private final ColDef colDef;
        private final int colIndex;
        private final int matchingCustomIndex;
        private final String formatCast;

        private Column(ColDef colDef, int colIndex, int matchingCustomIndex) {
            this.colDef = colDef;
            this.colIndex = colIndex;
            this.matchingCustomIndex = matchingCustomIndex;
            this.formatCast = colDef.getCastType();
        }
    }
}

