/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen.writers;

import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import java.io.IOException;
import java.time.LocalDate;
import net.fichotheque.alias.AliasHolder;
import net.mapeadores.util.money.MoneyLong;

public class CegidComptagenWriter
implements ComptagenWriter {
    private final Appendable appendable;
    private final AliasHolder coreAliasHolder;
    private final int maxLength = 35;
    private final int exportFractionDigits;

    public CegidComptagenWriter(Appendable appendable, AliasHolder coreAliasHolder, int exportFractionDigits) {
        this.appendable = appendable;
        this.coreAliasHolder = coreAliasHolder;
        this.exportFractionDigits = exportFractionDigits;
    }

    @Override
    public String getCharset() {
        return "windows-1252";
    }

    @Override
    public String getExtension() {
        return ".csv";
    }

    @Override
    public void writeLigne(ComptagenLigne ligne) throws IOException {
        String date = CegidComptagenWriter.toCegidFormat(ligne.getDate());
        String journal = ligne.getJournal().getCode();
        if (journal.length() > 3) {
            journal = journal.substring(0, 3);
        }
        String piece = ligne.getPieceRef();
        String libelle = this.getLibelle(ligne);
        String montant = MoneyLong.toString((long)ligne.getExportMoneyLong(), (int)this.exportFractionDigits);
        montant = montant.replace('.', ',');
        boolean isDebit = ligne.isDebit();
        this.first(journal);
        this.next(date);
        this.next(ligne.getNumeroCompte());
        this.next(ligne.getNumeroCompteTiers());
        this.next(piece);
        this.next(libelle);
        this.appendMontant(isDebit, montant);
        this.appendable.append("\r\n");
        String contrepartie = ligne.getNumeroContrepartie();
        if (contrepartie.length() > 0) {
            this.first(journal);
            this.next(date);
            this.next(ligne.getNumeroContrepartie());
            this.next("");
            this.next(piece);
            this.next(libelle);
            this.appendMontant(!isDebit, montant);
            this.appendable.append("\r\n");
        }
    }

    private void first(String s) throws IOException {
        this.appendable.append(s);
    }

    private void appendMontant(boolean isDebit, String montant) throws IOException {
        if (isDebit) {
            this.next(montant);
            this.next("0");
        } else {
            this.next("0");
            this.next(montant);
        }
    }

    private String getLibelle(ComptagenLigne ligne) throws IOException {
        String libelle = ComptagenUtils.getShortTitle(ligne, 35);
        if (libelle.indexOf(59) > -1 || libelle.indexOf(34) > -1) {
            libelle = libelle.replace("\"", "\"\"");
            return "\"" + libelle + "\"";
        }
        return libelle;
    }

    private void next(String s) throws IOException {
        this.appendable.append(';');
        this.appendable.append(s);
    }

    private static String toCegidFormat(LocalDate date) {
        String dateiso = date.toString();
        StringBuilder buf = new StringBuilder();
        buf.append(dateiso.substring(8));
        buf.append('/');
        buf.append(dateiso.substring(5, 7));
        buf.append('/');
        buf.append(dateiso.substring(0, 4));
        return buf.toString();
    }
}

