/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen;

import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.Compte;
import net.fichotheque.alias.AliasChecker;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.alias.AliasUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;

public final class ComptagenUtils {
    public static final AliasChecker COMPTAGEN_ALIASCHECKER = new ComptagenAliasChecker();

    private ComptagenUtils() {
    }

    public static String getShortTitle(ComptagenLigne ligne, int maxLength) {
        String shortTitle = ligne.getShortTitle();
        if (shortTitle == null || shortTitle.isEmpty()) {
            int currentLength;
            shortTitle = ligne.getLibelle();
            String beneficiaireString = ligne.getBeneficiaireString();
            if (beneficiaireString.length() > 0) {
                shortTitle = beneficiaireString + "/" + shortTitle;
            }
            if ((currentLength = shortTitle.length()) > maxLength) {
                shortTitle = shortTitle.substring(0, maxLength);
            }
        }
        return shortTitle;
    }

    public static Compte toCompte(String numero, String libelle) {
        return new InternalCompte(numero, libelle);
    }

    public static Compte toCompte(Motcle motcle, Lang lang) {
        return new InternalCompte(motcle.getIdalpha(), motcle.getLabelString(lang));
    }

    private static class InternalCompte
    implements Compte {
        private final String numero;
        private final String libelle;

        private InternalCompte(String numero, String libelle) {
            this.numero = numero;
            this.libelle = libelle;
        }

        @Override
        public String getNumero() {
            return this.numero;
        }

        @Override
        public String getLibelle() {
            return this.libelle;
        }
    }

    private static class ComptagenAliasChecker
    implements AliasChecker {
        private ComptagenAliasChecker() {
        }

        public short checkCorpusAlias(String alias) {
            return 0;
        }

        public short checkThesaurusAlias(String alias) {
            switch (alias) {
                case "plancomptable": {
                    return 2;
                }
                case "comptetiers": {
                    return 1;
                }
            }
            return 0;
        }

        public short checkFieldAlias(String corpusAlias, String fieldAlias) {
            if (corpusAlias.equals("mouvement")) {
                switch (fieldAlias) {
                    case "mouvement_facture": {
                        return 1;
                    }
                }
                return 0;
            }
            return 0;
        }

        public boolean testFieldValidity(String alias, CorpusField corpusField, MessageHandler messageHandler) {
            switch (alias) {
                case "mouvement_facture": {
                    return AliasUtils.testItemProp((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
            }
            return false;
        }
    }
}

