/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatUnit;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.tools.analytique.NaturalEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AnalytiqueRecapBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.RecapEngine;

class NaturalRecapEngine
extends RecapEngine {
    NaturalRecapEngine(NaturalEngineParameters naturalEngineParameters) {
        this.setCustomCurrencies(naturalEngineParameters.getCurrencies());
    }

    @Override
    public void addAgregat(AgregatBuilder agregatBuilder, AgregatGathering agregatGathering) {
        MoneyByCurrency moneyByCurrency = agregatGathering.getMoneyByCurrency();
        if (moneyByCurrency.isEmpty()) {
            return;
        }
        agregatBuilder.add(moneyByCurrency);
        for (AgregatUnit agregatUnit : agregatGathering.getUnitList()) {
            agregatBuilder.add(agregatUnit.getSubsetItem(), agregatUnit.getMoneyByCurrency());
        }
    }

    @Override
    public void addApport(AnalytiqueRecapBuilder analytiqueRecapBuilder, Ligne ligne) {
        long lg = ligne.getComputeMoneyLong();
        int currencyIndex = ligne.getMouvement().getCurrencyIndex();
        analytiqueRecapBuilder.addApport(currencyIndex, lg, ligne.getDate());
    }

    @Override
    public void addAvanceNonSoldee(AnalytiqueRecapBuilder analytiqueRecapBuilder, Ligne ligne) {
        long lg = ligne.getComputeMoneyLong();
        int currencyIndex = ligne.getMouvement().getCurrencyIndex();
        analytiqueRecapBuilder.addAvanceNonSoldee(currencyIndex, -lg, ligne.getDate());
    }

    @Override
    public void addDepense(AnalytiqueRecapBuilder analytiqueRecapBuilder, Ligne ligne) {
        long lg = ligne.getComputeMoneyLong();
        int currencyIndex = ligne.getMouvement().getCurrencyIndex();
        analytiqueRecapBuilder.addDepense(currencyIndex, -lg, ligne.getDate());
    }

    @Override
    public void addDepenseAvenir(AnalytiqueRecapBuilder analytiqueRecapBuilder, Avenir avenir) {
        long lg = avenir.getComputeMoneyLong();
        int currencyIndex = avenir.getCurrencyIndex();
        analytiqueRecapBuilder.addDepenseAvenir(currencyIndex, -lg, avenir.getDatePrevue());
    }
}

