/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AvenirDetail;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.Comparators;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnalytiqueDetailBuilder {
    private static final List<AnalytiqueDetail> EMPTY_SUBDETAILLIST = Collections.emptyList();
    private static final List<LigneDetail> EMPTY_LIGNEDETAILLIST = Collections.emptyList();
    private static final List<AvenirDetail> EMPTY_AVENIRDETAILLIST = Collections.emptyList();
    private final Object detailObject;
    private final List<LigneDetail> ligneDetailList = new ArrayList<LigneDetail>();
    private final List<AvenirDetail> avenirDetailList = new ArrayList<AvenirDetail>();
    private final List<AnalytiqueDetail> subDetailList = new ArrayList<AnalytiqueDetail>();
    private MoneyByCurrency lignesBeforeStart;
    private MoneyByCurrency avenirBeforeStart;
    private boolean ligneEmpty = true;
    private boolean avenirEmpty = true;

    public AnalytiqueDetailBuilder(Object detailObject) {
        this.detailObject = detailObject;
    }

    public AnalytiqueDetailBuilder addSubDetail(AnalytiqueDetail analytiqueDetail) {
        this.subDetailList.add(analytiqueDetail);
        if (!analytiqueDetail.isLigneEmpty()) {
            this.ligneEmpty = false;
        }
        if (!analytiqueDetail.isAvenirEmpty()) {
            this.avenirEmpty = false;
        }
        return this;
    }

    public AnalytiqueDetailBuilder addLigneDetail(LigneDetail ligneDetail) {
        this.ligneDetailList.add(ligneDetail);
        return this;
    }

    public AnalytiqueDetailBuilder addAvenirDetail(AvenirDetail avenirDetail) {
        this.avenirDetailList.add(avenirDetail);
        return this;
    }

    public AnalytiqueDetailBuilder setLignesBeforeStart(MoneyByCurrency lignesBeforeStart) {
        this.lignesBeforeStart = lignesBeforeStart;
        return this;
    }

    public AnalytiqueDetailBuilder setAvenirBeforeStart(MoneyByCurrency avenirBeforeStart) {
        this.avenirBeforeStart = avenirBeforeStart;
        return this;
    }

    public AnalytiqueDetail toAnalytiqueDetail() {
        int ligneSize = this.ligneDetailList.size();
        int avenirSize = this.avenirDetailList.size();
        if (this.ligneEmpty) {
            if (ligneSize != 0) {
                this.ligneEmpty = false;
            } else if (this.lignesBeforeStart != null && !this.lignesBeforeStart.isEmpty()) {
                this.ligneEmpty = false;
            }
        }
        if (this.avenirEmpty) {
            if (avenirSize != 0) {
                this.avenirEmpty = false;
            } else if (this.avenirBeforeStart != null && !this.avenirBeforeStart.isEmpty()) {
                this.avenirEmpty = false;
            }
        }
        Collections.sort(this.ligneDetailList, Comparators.LIGNEDETAIL_DATE);
        Collections.sort(this.avenirDetailList, Comparators.AVENIRDETAIL_DATE);
        int size = this.subDetailList.size();
        List<AnalytiqueDetail> finalSubDetailList = size == 0 ? EMPTY_SUBDETAILLIST : AnalytiqueUtils.wrap(this.subDetailList.toArray(new AnalytiqueDetail[size]));
        List<LigneDetail> finalLigneDetailList = ligneSize == 0 ? EMPTY_LIGNEDETAILLIST : AnalytiqueUtils.wrap(this.ligneDetailList.toArray(new LigneDetail[ligneSize]));
        List<AvenirDetail> finalAvenirDetailList = avenirSize == 0 ? EMPTY_AVENIRDETAILLIST : AnalytiqueUtils.wrap(this.avenirDetailList.toArray(new AvenirDetail[avenirSize]));
        return new InternalAnalytiqueDetail(this.detailObject, this.lignesBeforeStart, this.avenirBeforeStart, finalLigneDetailList, finalAvenirDetailList, finalSubDetailList, this.ligneEmpty, this.avenirEmpty);
    }

    public static AnalytiqueDetailBuilder init(Object detailObject) {
        return new AnalytiqueDetailBuilder(detailObject);
    }

    private static class InternalAnalytiqueDetail
    implements AnalytiqueDetail {
        private final Object detailObject;
        private final List<LigneDetail> ligneDetailList;
        private final List<AvenirDetail> avenirDetailList;
        private final List<AnalytiqueDetail> subDetailList;
        private final MoneyByCurrency lignesBeforeStart;
        private final MoneyByCurrency avenirBeforeStart;
        private final boolean ligneEmpty;
        private final boolean avenirEmpty;

        private InternalAnalytiqueDetail(Object detailObject, MoneyByCurrency lignesBeforeStart, MoneyByCurrency avenirBeforeStart, List<LigneDetail> ligneDetailList, List<AvenirDetail> avenirDetailList, List<AnalytiqueDetail> sousdetailList, boolean ligneEmpty, boolean avenirEmpty) {
            this.detailObject = detailObject;
            this.lignesBeforeStart = lignesBeforeStart;
            this.avenirBeforeStart = avenirBeforeStart;
            this.ligneDetailList = ligneDetailList;
            this.avenirDetailList = avenirDetailList;
            this.subDetailList = sousdetailList;
            this.ligneEmpty = ligneEmpty;
            this.avenirEmpty = avenirEmpty;
        }

        @Override
        public Object getDetailObject() {
            return this.detailObject;
        }

        @Override
        public List<LigneDetail> getLigneDetailList() {
            return this.ligneDetailList;
        }

        @Override
        public List<AvenirDetail> getAvenirDetailList() {
            return this.avenirDetailList;
        }

        @Override
        public List<AnalytiqueDetail> getSubDetailList() {
            return this.subDetailList;
        }

        @Override
        public boolean isLigneEmpty() {
            return this.ligneEmpty;
        }

        @Override
        public boolean isAvenirEmpty() {
            return this.avenirEmpty;
        }

        @Override
        public MoneyByCurrency getLignesBeforeStart() {
            return this.lignesBeforeStart;
        }

        @Override
        public MoneyByCurrency getAvenirBeforeStart() {
            return this.avenirBeforeStart;
        }
    }
}

