/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.LigneKey;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.time.LocalDate;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ScarabeUtils {
    public static final String DEPENSE_RACCOURCI = "DE";
    public static final String DEPENSE_AVENIR_RACCOURCI = "DF";
    public static final String APPORT_RACCOURCI = "AP";
    public static final String AVANCE_RACCOURCI = "AV";
    public static final String SOLDE_AVANCE_RACCOURCI = "SA";

    private ScarabeUtils() {
    }

    public static SubsetItem getSubsetItem(Object object) {
        if (object instanceof AnalytiqueItem) {
            return ((AnalytiqueItem)object).getSubsetItem();
        }
        if (object instanceof AnalytiqueGathering.SubCorpus) {
            return ((AnalytiqueGathering.SubCorpus)object).getFicheMeta();
        }
        if (object instanceof AnalytiqueGathering.Groupby) {
            return ((AnalytiqueGathering.Groupby)object).getMotcle();
        }
        return null;
    }

    public static String getLibelle(Object object, Lang workingLang) {
        SubsetItem subsetItem = ScarabeUtils.getSubsetItem(object);
        if (subsetItem != null) {
            return ScarabeUtils.getLibelle(subsetItem, workingLang);
        }
        return "";
    }

    public static String getShortLibelle(Object object, Lang workingLang) {
        SubsetItem subsetItem = ScarabeUtils.getSubsetItem(object);
        if (subsetItem != null) {
            return ScarabeUtils.getShortLibelle(subsetItem, workingLang);
        }
        return "";
    }

    public static String getIdalpha(Object object, Lang workingLang) {
        SubsetItem subsetItem = ScarabeUtils.getSubsetItem(object);
        if (subsetItem != null) {
            return ScarabeUtils.getIdalpha(subsetItem, workingLang);
        }
        return "";
    }

    public static String getLibelle(SubsetItem subsetItem, Lang workingLang) {
        if (subsetItem instanceof FicheMeta) {
            return ((FicheMeta)subsetItem).getTitle();
        }
        if (subsetItem instanceof Motcle) {
            Motcle motcle = (Motcle)subsetItem;
            return ThesaurusUtils.getMotcleTitle((Motcle)motcle, (Lang)workingLang, (boolean)false, (boolean)true);
        }
        return "";
    }

    public static String getShortLibelle(SubsetItem subsetItem, Lang workingLang) {
        if (subsetItem instanceof FicheMeta) {
            return ((FicheMeta)subsetItem).getTitle();
        }
        if (subsetItem instanceof Motcle) {
            Motcle motcle = (Motcle)subsetItem;
            String idalpha = motcle.getIdalpha();
            if (idalpha == null) {
                return motcle.getLabelString(workingLang);
            }
            return idalpha;
        }
        return "";
    }

    public static String getIdalpha(SubsetItem subsetItem, Lang workingLang) {
        Motcle motcle;
        String idalpha;
        if (subsetItem instanceof Motcle && (idalpha = (motcle = (Motcle)subsetItem).getIdalpha()) != null) {
            return idalpha;
        }
        return "";
    }

    public static String getRaccourci(LigneKey ligneKey) {
        if (ligneKey.isSoldeAvance()) {
            return SOLDE_AVANCE_RACCOURCI;
        }
        switch (ligneKey.getAlias()) {
            case "depense": {
                return DEPENSE_RACCOURCI;
            }
            case "apport": {
                return APPORT_RACCOURCI;
            }
            case "avance": {
                return AVANCE_RACCOURCI;
            }
        }
        throw new SwitchException("Wrong ligne alias: " + ligneKey.getAlias());
    }

    public static String checkLibelle(Ligne ligne, ScarabeLocalisation scarabeLocalisation) {
        String libelle = ligne.getLibelle();
        AvanceInfo avanceInfo = ligne.getAvanceInfo();
        if (avanceInfo == null || !avanceInfo.isAvanceSoldee()) {
            return libelle;
        }
        LigneKey ligneKey = ligne.getLigneKey();
        MessageLocalisation messageLocalisation = scarabeLocalisation.getMessageLocalisation();
        if (ligneKey.isSoldeAvance()) {
            String dateString = "";
            LocalDate date = avanceInfo.getAvanceDate();
            if (date != null) {
                dateString = scarabeLocalisation.getMediumDateFormatter().format(date);
            }
            return messageLocalisation.toString("_ label.scarabe.soldeavance", new Object[]{dateString, libelle});
        }
        String dateString = "";
        LocalDate date = avanceInfo.getSoldeAvanceDate();
        if (date != null) {
            dateString = scarabeLocalisation.getMediumDateFormatter().format(date);
        }
        return messageLocalisation.toString("_ label.scarabe.datesolde", new Object[]{dateString, libelle});
    }

    public static String getInitL10nKey(ScarabeContext scarabeContext) {
        switch (scarabeContext.getInitState()) {
            case 4: {
                return "_ warning.scarabe.init_error";
            }
            case 2: {
                return "_ warning.scarabe.init_uninstalled";
            }
            case 3: {
                return "_ warning.scarabe.init_oldversion";
            }
            case 1: {
                return "_ info.scarabe.init_ok";
            }
        }
        throw new SwitchException("Unknown init state: " + scarabeContext.getInitState());
    }

    public static void checkInitState(ScarabeContext scarabeContext) throws ErrorMessageException {
        if (scarabeContext.getInitState() != 1) {
            throw BdfErrors.error((String)ScarabeUtils.getInitL10nKey(scarabeContext));
        }
    }
}

