/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools;

import fr.exemole.bdfext.scarabe.api.analytique.AvenirDetail;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.LigneKey;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import java.util.Comparator;

public class Comparators {
    public static final Comparator<Mouvement> MOUVEMENT_NUMEROPIECE = new MouvementNumeropieceComparator();
    public static final Comparator<LigneKey> LIGNEKEY = new LigneKeyComparator();
    public static final Comparator<Ligne> LIGNE_DATE = new LigneDateComparator();
    public static final Comparator<Avenir> AVENIR_DATE = new AvenirDateComparator();
    public static final Comparator<LigneDetail> LIGNEDETAIL_DATE = new LigneDetailDateComparator();
    public static final Comparator<AvenirDetail> AVENIRDETAIL_DATE = new AvenirDetailDateComparator();

    private static class MouvementNumeropieceComparator
    implements Comparator<Mouvement> {
        private MouvementNumeropieceComparator() {
        }

        @Override
        public int compare(Mouvement mouvement1, Mouvement mouvement2) {
            int id2;
            int piece2;
            int piece1 = mouvement1.getNumeropiece();
            if (piece1 < (piece2 = mouvement2.getNumeropiece())) {
                return -1;
            }
            if (piece1 > piece2) {
                return 1;
            }
            int comp = mouvement1.getDate().compareTo(mouvement2.getDate());
            if (comp != 0) {
                return comp;
            }
            int id1 = mouvement1.getId();
            if (id1 < (id2 = mouvement2.getId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }
    }

    private static class LigneKeyComparator
    implements Comparator<LigneKey> {
        private LigneKeyComparator() {
        }

        @Override
        public int compare(LigneKey ligneKey1, LigneKey ligneKey2) {
            String alias2;
            String alias1 = ligneKey1.getAlias();
            if (alias1.equals(alias2 = ligneKey2.getAlias())) {
                int id2;
                int id1;
                if (alias1.equals("avance")) {
                    boolean b1 = ligneKey1.isSoldeAvance();
                    boolean b2 = ligneKey2.isSoldeAvance();
                    if (b1 && !b2) {
                        return 1;
                    }
                    if (!b1 && b2) {
                        return -1;
                    }
                }
                if ((id1 = ligneKey1.getId()) < (id2 = ligneKey2.getId())) {
                    return -1;
                }
                if (id1 > id2) {
                    return 1;
                }
                return 0;
            }
            if (alias1.equals("avance")) {
                return -1;
            }
            if (alias2.equals("avance")) {
                return 1;
            }
            if (alias1.equals("depense")) {
                return -1;
            }
            return 1;
        }
    }

    private static class LigneDateComparator
    implements Comparator<Ligne> {
        private LigneDateComparator() {
        }

        @Override
        public int compare(Ligne ligne1, Ligne ligne2) {
            int piece2;
            int comp = ligne1.getDate().compareTo(ligne2.getDate());
            if (comp != 0) {
                return comp;
            }
            int piece1 = ligne1.getMouvement().getNumeropiece();
            if (piece1 < (piece2 = ligne2.getMouvement().getNumeropiece())) {
                return -1;
            }
            if (piece1 > piece2) {
                return 1;
            }
            return LIGNEKEY.compare(ligne1.getLigneKey(), ligne2.getLigneKey());
        }
    }

    private static class AvenirDateComparator
    implements Comparator<Avenir> {
        private AvenirDateComparator() {
        }

        @Override
        public int compare(Avenir avenir1, Avenir avenir2) {
            int id2;
            int comp = avenir1.getDatePrevue().compareTo(avenir2.getDatePrevue());
            if (comp != 0) {
                return comp;
            }
            int id1 = avenir1.getFicheMeta().getId();
            if (id1 < (id2 = avenir2.getFicheMeta().getId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }
    }

    private static class LigneDetailDateComparator
    implements Comparator<LigneDetail> {
        private LigneDetailDateComparator() {
        }

        @Override
        public int compare(LigneDetail ligneDetail1, LigneDetail ligneDetail2) {
            return LIGNE_DATE.compare(ligneDetail1.getLigne(), ligneDetail2.getLigne());
        }
    }

    private static class AvenirDetailDateComparator
    implements Comparator<AvenirDetail> {
        private AvenirDetailDateComparator() {
        }

        @Override
        public int compare(AvenirDetail avenirDetail1, AvenirDetail avenirDetail2) {
            return AVENIR_DATE.compare(avenirDetail1.getAvenir(), avenirDetail2.getAvenir());
        }
    }
}

