/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.selection;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.commands.SelectionParameters;
import fr.exemole.bdfext.scarabe.selection.ScarabeSelectionUtils;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.FieldTest;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.PointeurUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.MotcleConditionBuilder;
import net.fichotheque.utils.selection.MotcleConditionPredicateFactory;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DecimalLong;
import net.mapeadores.util.primitives.DecimalLongFilter;

public class MouvementFicheSelector
implements FicheSelector {
    private final BdfServer bdfServer;
    private final ScarabeContext scarabeContext;
    private final Corpus mouvementCorpus;
    private final FichePointeur mouvementPointeur;
    private final Lang lang;
    private final SelectionParameters selectionParameters;
    private Predicate<FicheMeta> motcleConditionPredicate;
    private FieldTest[] fieldTestArray;

    public MouvementFicheSelector(BdfServer bdfServer, ScarabeContext scarabeContext, BdfUser bdfUser, SelectionParameters selectionParameters) {
        this.bdfServer = bdfServer;
        this.scarabeContext = scarabeContext;
        this.mouvementCorpus = scarabeContext.getCoreAliasHolder().getCorpus("mouvement");
        this.lang = bdfUser.getWorkingLang();
        this.selectionParameters = selectionParameters;
        this.mouvementPointeur = PointeurFactory.newFichePointeur((Corpus)this.mouvementCorpus);
        this.init();
    }

    private void init() {
        AliasHolder coreAliasHolder = this.scarabeContext.getCoreAliasHolder();
        ArrayList<FieldTest> fieldTestList = new ArrayList<FieldTest>();
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder((BdfServer)this.bdfServer, (Lang)this.lang).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
        ScarabeSelectionUtils.addFieldTest(fieldTestList, (TextCondition)this.selectionParameters.getValue("beneficiaire"), selectionContext, coreAliasHolder.getCorpusField("mouvement_beneficiaire"));
        ScarabeSelectionUtils.addFieldTest(fieldTestList, (TextCondition)this.selectionParameters.getValue("libelle"), selectionContext, coreAliasHolder.getCorpusField("mouvement_libelle"));
        ScarabeSelectionUtils.addFieldTest(fieldTestList, this.selectionParameters.getValue("date"), coreAliasHolder.getCorpusField("mouvement_date"));
        ScarabeSelectionUtils.addFieldTest(fieldTestList, this.selectionParameters.getValue("numeropiece"), coreAliasHolder.getCorpusField("mouvement_numeropiece"));
        ScarabeSelectionUtils.addFieldTest(fieldTestList, this.selectionParameters.getValue("numerocheque"), coreAliasHolder.getCorpusField("mouvement_numerocheque"));
        DecimalLongFilter montantLongFilter = (DecimalLongFilter)this.selectionParameters.getValue("montant");
        if (montantLongFilter != null) {
            CorpusField debitMontantField = coreAliasHolder.getCorpusField("mouvement_montantdebit");
            CorpusField creditMontantField = coreAliasHolder.getCorpusField("mouvement_montantcredit");
            fieldTestList.add(new MontantFieldTest(debitMontantField.getFieldKey(), creditMontantField.getFieldKey(), montantLongFilter));
        }
        int fieldTestSize = fieldTestList.size();
        this.fieldTestArray = fieldTestList.toArray(new FieldTest[fieldTestSize]);
        MotcleConditionBuilder motcleConditionBuilder = MotcleConditionBuilder.init().setLogicalOperator("and");
        this.appendMotcleQuery(motcleConditionBuilder, "banque");
        this.appendMotcleQuery(motcleConditionBuilder, "rapprochement");
        this.appendMotcleQuery(motcleConditionBuilder, "modepaiement");
        if (!motcleConditionBuilder.isEmpty()) {
            this.motcleConditionPredicate = MotcleConditionPredicateFactory.newInstance((SelectionContext)selectionContext, (MotcleCondition)motcleConditionBuilder.toMotcleCondition());
        }
    }

    private void appendMotcleQuery(MotcleConditionBuilder motcleConditionBuilder, String paramName) {
        TextCondition fieldCondition = (TextCondition)this.selectionParameters.getValue(paramName);
        if (fieldCondition == null) {
            return;
        }
        SubsetKey thesaurusKey = this.toThesaurusKey(paramName);
        if (thesaurusKey == null) {
            return;
        }
        motcleConditionBuilder.addEntry(SelectionUtils.toMotcleConditionEntry((MotcleQuery)MotcleQueryBuilder.init().addThesaurus((Object)thesaurusKey).setContentCondition(fieldCondition, "idalpha_only").toMotcleQuery()));
    }

    public List<Corpus> getCorpusList() {
        return Collections.singletonList(this.mouvementCorpus);
    }

    public Junction isSelected(FicheMeta ficheMeta, Junction junction) {
        if (this.test(ficheMeta)) {
            return junction;
        }
        return null;
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public boolean test(FicheMeta ficheMeta) {
        this.mouvementPointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
        if (this.motcleConditionPredicate != null && !this.motcleConditionPredicate.test(ficheMeta)) {
            return false;
        }
        for (FieldTest fieldTest : this.fieldTestArray) {
            if (fieldTest.success(this.mouvementPointeur)) continue;
            return false;
        }
        return true;
    }

    public CoreUtils.Lists getCurrentMouvementLists() {
        return CoreUtils.getLists(this.mouvementPointeur, this.scarabeContext.getCoreAliasHolder());
    }

    private SubsetKey toThesaurusKey(String paramName) {
        SubsetKey subsetKey = null;
        AliasHolder aliasHolder = this.scarabeContext.getCoreAliasHolder();
        if (paramName.equals("banque")) {
            subsetKey = aliasHolder.getThesaurus("banque").getSubsetKey();
        } else if (paramName.equals("rapprochement")) {
            subsetKey = aliasHolder.getThesaurus("rapprochement").getSubsetKey();
        } else if (paramName.equals("modepaiement")) {
            subsetKey = aliasHolder.getThesaurus("modepaiement").getSubsetKey();
        }
        return subsetKey;
    }

    private static class MontantFieldTest
    implements FieldTest {
        private final FieldKey debitMontantFieldKey;
        private final FieldKey creditMontantFieldKey;
        private final DecimalLongFilter montantLongFilter;

        private MontantFieldTest(FieldKey debitMontantFieldKey, FieldKey creditMontantFieldKey, DecimalLongFilter montantLongFilter) {
            this.debitMontantFieldKey = debitMontantFieldKey;
            this.creditMontantFieldKey = creditMontantFieldKey;
            this.montantLongFilter = montantLongFilter;
        }

        public boolean success(FichePointeur fichePointeur) {
            AmountItem montant = PointeurUtils.getAmount((FichePointeur)fichePointeur, (FieldKey)this.debitMontantFieldKey);
            if (montant == null) {
                montant = PointeurUtils.getAmount((FichePointeur)fichePointeur, (FieldKey)this.creditMontantFieldKey);
            }
            if (montant == null) {
                return false;
            }
            long lg = DecimalLong.toDecimalLong((Decimal)montant.getDecimal());
            return this.montantLongFilter.containsDecimalLong(lg);
        }
    }
}

