/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.json;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.ItemAnalytiqueDetails;
import fr.exemole.bdfext.scarabe.json.AnalytiqueDetailJson;
import fr.exemole.bdfext.scarabe.json.AnalytiqueRecapJson;
import fr.exemole.bdfext.scarabe.json.JsonUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import java.io.IOException;
import net.fichotheque.exportation.table.CellConverter;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.money.Currencies;

public class AnalytiqueItemJsonProperty
implements JsonProperty {
    private final BdfParameters bdfParameters;
    private final ScarabeContext scarabeContext;
    private final ItemAnalytiqueDetails itemAnalytiqueDetails;
    private final AnalytiqueRecap analytiqueRecap;
    private final boolean recursive;
    private final CellConverter ligneCellConverter;
    private final CellConverter recapCellConverter;

    public AnalytiqueItemJsonProperty(BdfParameters bdfParameters, ScarabeContext scarabeContext, ItemAnalytiqueDetails itemAnalytiqueDetails, AnalytiqueRecap analytiqueRecap, CellConverter ligneCellConverter, CellConverter recapCellConverter, boolean recursive) {
        this.bdfParameters = bdfParameters;
        this.scarabeContext = scarabeContext;
        this.itemAnalytiqueDetails = itemAnalytiqueDetails;
        this.analytiqueRecap = analytiqueRecap;
        this.ligneCellConverter = ligneCellConverter;
        this.recapCellConverter = recapCellConverter;
        this.recursive = recursive;
    }

    public String getName() {
        return "analytiqueitem";
    }

    public void writeValue(JSONWriter jw) throws IOException {
        ScarabeLocalisation scarabeLocalisation = ScarabeLocalisation.build(this.bdfParameters);
        Currencies currencies = this.itemAnalytiqueDetails.getCustomCurrencies();
        AnalytiqueDetail analytiqueDetail = this.itemAnalytiqueDetails.getAnalytiqueDetail();
        jw.object();
        JsonUtils.properties(jw, this.itemAnalytiqueDetails.getAnalytiqueItem().getSubsetItem(), scarabeLocalisation, this.recapCellConverter);
        if (this.analytiqueRecap != null) {
            AnalytiqueRecapJson.operationsProperty(jw, this.analytiqueRecap, scarabeLocalisation, this.recapCellConverter);
            AnalytiqueRecapJson.chronologyProperty(jw, this.analytiqueRecap);
        }
        AnalytiqueDetailJson.lignesProperty(jw, "lignes", analytiqueDetail, scarabeLocalisation, currencies, this.ligneCellConverter);
        AnalytiqueDetailJson.avenirsProperty(jw, "avenirs", analytiqueDetail, currencies, this.ligneCellConverter);
        jw.endObject();
    }
}

