/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.json;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.json.JsonUtils;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import java.io.IOException;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.json.CellJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.money.Currencies;

public final class LigneDetailJson {
    private LigneDetailJson() {
    }

    public static void properties(JSONWriter jw, LigneDetail ligneDetail, ScarabeLocalisation scarabeLocalisation, Currencies currencies, CellConverter cellConverter) throws IOException {
        Ligne ligne = ligneDetail.getLigne();
        MoneyByCurrency moneyByCurrency = ligneDetail.getMoneyByCurrency();
        jw.key("corpus").value((Object)ligne.getFicheMeta().getSubsetName());
        jw.key("id").value((long)ligne.getId());
        jw.key("raccourci").value((Object)ScarabeUtils.getRaccourci(ligne.getLigneKey()));
        jw.key("date").value((Object)ligne.getDate().toString());
        jw.key("piece").value((long)ligne.getMouvement().getNumeropiece());
        jw.key("beneficiaire").value((Object)ligne.getBeneficiaireString());
        jw.key("libelle").value((Object)ScarabeUtils.checkLibelle(ligne, scarabeLocalisation));
        JsonUtils.properties(jw, moneyByCurrency, currencies);
        jw.key("montantorigine");
        jw.object();
        jw.key("currency").value((Object)ligne.getAmountItem().getCurrency().getCurrencyCode());
        jw.key("long").value(ligne.getComputeMoneyLong());
        jw.endObject();
        AvanceInfo avanceInfo = ligne.getAvanceInfo();
        if (avanceInfo != null) {
            jw.key("avance");
            jw.object();
            LigneDetailJson.properties(jw, avanceInfo, ligne.getLigneKey().isSoldeAvance());
            jw.endObject();
        }
        CellJson.cellArrayMappingProperty((JSONWriter)jw, (Cell[])cellConverter.toCellArray((SubsetItem)ligne.getFicheMeta()));
    }

    private static void properties(JSONWriter jw, AvanceInfo avanceInfo, boolean solde) throws IOException {
        jw.key("solde").value(solde);
        jw.key("soldee").value(avanceInfo.isAvanceSoldee());
        jw.key("depenseArray");
        jw.array();
        for (AvanceInfo.DepenseInfo depenseInfo : avanceInfo.getDepenseInfoList()) {
            FicheMeta ficheMeta = depenseInfo.getFicheMeta();
            jw.object();
            jw.key("id").value((long)ficheMeta.getId());
            jw.key("titre").value((Object)ficheMeta.getTitle());
            jw.key("montantorigine");
            jw.object();
            jw.key("currency").value((Object)depenseInfo.getCurrency().getCurrencyCode());
            jw.key("long").value(-depenseInfo.getMoneyLong());
            jw.endObject();
            jw.endObject();
        }
        jw.endArray();
    }
}

