/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.json;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import java.io.IOException;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.json.CellJson;
import net.fichotheque.json.MetadataJson;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static void properties(JSONWriter jw, MoneyByCurrency moneyByCurrency, Currencies currencies) throws IOException {
        if (moneyByCurrency.isEmpty()) {
            return;
        }
        int currencyLength = currencies.size();
        jw.key("amount");
        jw.object();
        for (int i = 0; i < currencyLength; ++i) {
            if (!moneyByCurrency.withMoney(i)) continue;
            jw.key(((ExtendedCurrency)currencies.get(i)).getCurrencyCode()).value(moneyByCurrency.getMoneyLong(i));
        }
        jw.endObject();
    }

    public static void properties(JSONWriter jw, SubsetItem subsetItem, ScarabeLocalisation scarabeLocalisation, CellConverter cellConverter) throws IOException {
        Motcle motcle;
        String idalpha;
        MetadataJson.subsetProperty((JSONWriter)jw, (SubsetKey)subsetItem.getSubsetKey());
        jw.key("id").value((long)subsetItem.getId());
        if (subsetItem instanceof Motcle && (idalpha = (motcle = (Motcle)subsetItem).getIdalpha()) != null) {
            jw.key("idalpha").value((Object)idalpha);
            jw.key("label").value((Object)motcle.getLabelString(scarabeLocalisation.getWorkingLang()));
        }
        jw.key("title").value((Object)ScarabeUtils.getLibelle(subsetItem, scarabeLocalisation.getWorkingLang()));
        if (cellConverter != null) {
            CellJson.cellArrayMappingProperty((JSONWriter)jw, (Cell[])cellConverter.toCellArray(subsetItem));
        }
    }
}

