/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.json;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AvenirDetail;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.json.AvenirDetailJson;
import fr.exemole.bdfext.scarabe.json.JsonUtils;
import fr.exemole.bdfext.scarabe.json.LigneDetailJson;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import java.io.IOException;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.CellConverter;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.money.Currencies;

public final class AnalytiqueDetailJson {
    private AnalytiqueDetailJson() {
    }

    public static void properties(JSONWriter jw, AnalytiqueDetail analytiqueDetail, ScarabeLocalisation scarabeLocalisation, Currencies currencies, CellConverter cellConverter, boolean recursive) throws IOException {
        SubsetItem subsetItem = ScarabeUtils.getSubsetItem(analytiqueDetail.getDetailObject());
        jw.key("title");
        if (subsetItem != null) {
            jw.value((Object)ScarabeUtils.getLibelle(subsetItem, scarabeLocalisation.getWorkingLang()));
        } else {
            jw.value((Object)"");
        }
        if (subsetItem != null) {
            jw.key("item");
            jw.object();
            JsonUtils.properties(jw, subsetItem, scarabeLocalisation, null);
            jw.endObject();
        }
        AnalytiqueDetailJson.lignesProperty(jw, "lignes", analytiqueDetail, scarabeLocalisation, currencies, cellConverter);
        AnalytiqueDetailJson.avenirsProperty(jw, "avenirs", analytiqueDetail, currencies, cellConverter);
        if (recursive) {
            jw.key("subArray");
            jw.array();
            for (AnalytiqueDetail child : analytiqueDetail.getSubDetailList()) {
                jw.object();
                AnalytiqueDetailJson.properties(jw, child, scarabeLocalisation, currencies, cellConverter, true);
                jw.endObject();
            }
            jw.endArray();
        }
    }

    public static void lignesProperty(JSONWriter jw, String propertyName, AnalytiqueDetail analytiqueDetail, ScarabeLocalisation scarabeLocalisation, Currencies currencies, CellConverter cellConverter) throws IOException {
        jw.key(propertyName);
        jw.array();
        for (LigneDetail ligneDetail : analytiqueDetail.getLigneDetailList()) {
            jw.object();
            LigneDetailJson.properties(jw, ligneDetail, scarabeLocalisation, currencies, cellConverter);
            jw.endObject();
        }
        jw.endArray();
    }

    public static void avenirsProperty(JSONWriter jw, String propertyName, AnalytiqueDetail analytiqueDetail, Currencies currencies, CellConverter cellConverter) throws IOException {
        jw.key(propertyName);
        jw.array();
        for (AvenirDetail avenirDetail : analytiqueDetail.getAvenirDetailList()) {
            jw.object();
            AvenirDetailJson.properties(jw, avenirDetail, currencies, cellConverter);
            jw.endObject();
        }
        jw.endArray();
    }
}

