/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.core.DesherenceTest;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.tools.FichothequeTools;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class DesherenceRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DesherenceRemove";
    private FicheMeta ficheMeta;
    private final ScarabeContext scarabeContext;

    public DesherenceRemoveCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        Corpus corpus = this.ficheMeta.getCorpus();
        try (EditSession session = this.startEditSession(Scarabe.DOMAIN, COMMANDNAME);){
            FichothequeTools.remove((FichothequeEditor)session.getFichothequeEditor(), (FicheMeta)this.ficheMeta);
        }
        this.putResultObject("obj.corpus", corpus);
        this.setDone("_ done.scarabe.desherenceremove", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        ScarabeUtils.checkInitState(this.scarabeContext);
        this.ficheMeta = this.requestHandler.getMandatoryFicheMeta();
        if (!DesherenceTest.isDesherenceFiche(this.scarabeContext, this.ficheMeta)) {
            throw BdfErrors.error((String)"_ error.notremovable.scarabe.fiche_desherence");
        }
    }
}

